// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Ephemeris item.
 */
public class EphemerisItem private constructor(builder: Builder) {
    /**
     * The time the ephemeris was uploaded in UTC.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Whether or not the ephemeris is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The AWS Ground Station ephemeris ID.
     */
    public val ephemerisId: kotlin.String? = builder.ephemerisId
    /**
     * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
     *
     * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     *
     * Priority must be 1 or greater
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * Source S3 object used for the ephemeris.
     */
    public val sourceS3Object: aws.sdk.kotlin.services.groundstation.model.S3Object? = builder.sourceS3Object
    /**
     * The status of the ephemeris.
     */
    public val status: aws.sdk.kotlin.services.groundstation.model.EphemerisStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.EphemerisItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EphemerisItem(")
        append("creationTime=$creationTime,")
        append("enabled=$enabled,")
        append("ephemerisId=$ephemerisId,")
        append("name=$name,")
        append("priority=$priority,")
        append("sourceS3Object=$sourceS3Object,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (ephemerisId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (sourceS3Object?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EphemerisItem

        if (creationTime != other.creationTime) return false
        if (enabled != other.enabled) return false
        if (ephemerisId != other.ephemerisId) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (sourceS3Object != other.sourceS3Object) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.EphemerisItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time the ephemeris was uploaded in UTC.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Whether or not the ephemeris is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The AWS Ground Station ephemeris ID.
         */
        public var ephemerisId: kotlin.String? = null
        /**
         * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         */
        public var name: kotlin.String? = null
        /**
         * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
         *
         * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         *
         * Priority must be 1 or greater
         */
        public var priority: kotlin.Int? = null
        /**
         * Source S3 object used for the ephemeris.
         */
        public var sourceS3Object: aws.sdk.kotlin.services.groundstation.model.S3Object? = null
        /**
         * The status of the ephemeris.
         */
        public var status: aws.sdk.kotlin.services.groundstation.model.EphemerisStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.EphemerisItem) : this() {
            this.creationTime = x.creationTime
            this.enabled = x.enabled
            this.ephemerisId = x.ephemerisId
            this.name = x.name
            this.priority = x.priority
            this.sourceS3Object = x.sourceS3Object
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.EphemerisItem = EphemerisItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.groundstation.model.S3Object] inside the given [block]
         */
        public fun sourceS3Object(block: aws.sdk.kotlin.services.groundstation.model.S3Object.Builder.() -> kotlin.Unit) {
            this.sourceS3Object = aws.sdk.kotlin.services.groundstation.model.S3Object.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
