// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeEphemerisResponse private constructor(builder: Builder) {
    /**
     * The time the ephemeris was uploaded in UTC.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Whether or not the ephemeris is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The AWS Ground Station ephemeris ID.
     */
    public val ephemerisId: kotlin.String? = builder.ephemerisId
    /**
     * Reason that an ephemeris failed validation. Only provided for ephemerides with `INVALID` status.
     */
    public val invalidReason: aws.sdk.kotlin.services.groundstation.model.EphemerisInvalidReason? = builder.invalidReason
    /**
     * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
     *
     * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     *
     * Priority must be 1 or greater
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The AWS Ground Station satellite ID associated with ephemeris.
     */
    public val satelliteId: kotlin.String? = builder.satelliteId
    /**
     * The status of the ephemeris.
     */
    public val status: aws.sdk.kotlin.services.groundstation.model.EphemerisStatus? = builder.status
    /**
     * Supplied ephemeris data.
     */
    public val suppliedData: aws.sdk.kotlin.services.groundstation.model.EphemerisTypeDescription? = builder.suppliedData
    /**
     * Tags assigned to an ephemeris.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.DescribeEphemerisResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEphemerisResponse(")
        append("creationTime=$creationTime,")
        append("enabled=$enabled,")
        append("ephemerisId=$ephemerisId,")
        append("invalidReason=$invalidReason,")
        append("name=$name,")
        append("priority=$priority,")
        append("satelliteId=$satelliteId,")
        append("status=$status,")
        append("suppliedData=$suppliedData,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (ephemerisId?.hashCode() ?: 0)
        result = 31 * result + (invalidReason?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (satelliteId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (suppliedData?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEphemerisResponse

        if (creationTime != other.creationTime) return false
        if (enabled != other.enabled) return false
        if (ephemerisId != other.ephemerisId) return false
        if (invalidReason != other.invalidReason) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (satelliteId != other.satelliteId) return false
        if (status != other.status) return false
        if (suppliedData != other.suppliedData) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.DescribeEphemerisResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time the ephemeris was uploaded in UTC.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Whether or not the ephemeris is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The AWS Ground Station ephemeris ID.
         */
        public var ephemerisId: kotlin.String? = null
        /**
         * Reason that an ephemeris failed validation. Only provided for ephemerides with `INVALID` status.
         */
        public var invalidReason: aws.sdk.kotlin.services.groundstation.model.EphemerisInvalidReason? = null
        /**
         * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         */
        public var name: kotlin.String? = null
        /**
         * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
         *
         * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         *
         * Priority must be 1 or greater
         */
        public var priority: kotlin.Int? = null
        /**
         * The AWS Ground Station satellite ID associated with ephemeris.
         */
        public var satelliteId: kotlin.String? = null
        /**
         * The status of the ephemeris.
         */
        public var status: aws.sdk.kotlin.services.groundstation.model.EphemerisStatus? = null
        /**
         * Supplied ephemeris data.
         */
        public var suppliedData: aws.sdk.kotlin.services.groundstation.model.EphemerisTypeDescription? = null
        /**
         * Tags assigned to an ephemeris.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.DescribeEphemerisResponse) : this() {
            this.creationTime = x.creationTime
            this.enabled = x.enabled
            this.ephemerisId = x.ephemerisId
            this.invalidReason = x.invalidReason
            this.name = x.name
            this.priority = x.priority
            this.satelliteId = x.satelliteId
            this.status = x.status
            this.suppliedData = x.suppliedData
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.DescribeEphemerisResponse = DescribeEphemerisResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
