// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class CreateMissionProfileRequest private constructor(builder: Builder) {
    /**
     * Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event indicating the pass has finished.
     */
    public val contactPostPassDurationSeconds: kotlin.Int? = builder.contactPostPassDurationSeconds
    /**
     * Amount of time prior to contact start you’d like to receive a Ground Station Contact State Change event indicating an upcoming pass.
     */
    public val contactPrePassDurationSeconds: kotlin.Int? = builder.contactPrePassDurationSeconds
    /**
     * A list of lists of ARNs. Each list of ARNs is an edge, with a *from*`Config` and a *to*`Config`.
     */
    public val dataflowEdges: List<List<String>> = requireNotNull(builder.dataflowEdges) { "A non-null value must be provided for dataflowEdges" }
    /**
     * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.
     */
    public val minimumViableContactDurationSeconds: kotlin.Int = requireNotNull(builder.minimumViableContactDurationSeconds) { "A non-null value must be provided for minimumViableContactDurationSeconds" }
    /**
     * Name of a mission profile.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * KMS key to use for encrypting streams.
     */
    public val streamsKmsKey: aws.sdk.kotlin.services.groundstation.model.KmsKey? = builder.streamsKmsKey
    /**
     * Role to use for encrypting streams with KMS key.
     */
    public val streamsKmsRole: kotlin.String? = builder.streamsKmsRole
    /**
     * Tags assigned to a mission profile.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * ARN of a tracking `Config`.
     */
    public val trackingConfigArn: kotlin.String = requireNotNull(builder.trackingConfigArn) { "A non-null value must be provided for trackingConfigArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.CreateMissionProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMissionProfileRequest(")
        append("contactPostPassDurationSeconds=$contactPostPassDurationSeconds,")
        append("contactPrePassDurationSeconds=$contactPrePassDurationSeconds,")
        append("dataflowEdges=$dataflowEdges,")
        append("minimumViableContactDurationSeconds=$minimumViableContactDurationSeconds,")
        append("name=$name,")
        append("streamsKmsKey=$streamsKmsKey,")
        append("streamsKmsRole=$streamsKmsRole,")
        append("tags=$tags,")
        append("trackingConfigArn=$trackingConfigArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactPostPassDurationSeconds ?: 0
        result = 31 * result + (contactPrePassDurationSeconds ?: 0)
        result = 31 * result + (dataflowEdges.hashCode())
        result = 31 * result + (minimumViableContactDurationSeconds)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (streamsKmsKey?.hashCode() ?: 0)
        result = 31 * result + (streamsKmsRole?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trackingConfigArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMissionProfileRequest

        if (contactPostPassDurationSeconds != other.contactPostPassDurationSeconds) return false
        if (contactPrePassDurationSeconds != other.contactPrePassDurationSeconds) return false
        if (dataflowEdges != other.dataflowEdges) return false
        if (minimumViableContactDurationSeconds != other.minimumViableContactDurationSeconds) return false
        if (name != other.name) return false
        if (streamsKmsKey != other.streamsKmsKey) return false
        if (streamsKmsRole != other.streamsKmsRole) return false
        if (tags != other.tags) return false
        if (trackingConfigArn != other.trackingConfigArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.CreateMissionProfileRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event indicating the pass has finished.
         */
        public var contactPostPassDurationSeconds: kotlin.Int? = null
        /**
         * Amount of time prior to contact start you’d like to receive a Ground Station Contact State Change event indicating an upcoming pass.
         */
        public var contactPrePassDurationSeconds: kotlin.Int? = null
        /**
         * A list of lists of ARNs. Each list of ARNs is an edge, with a *from*`Config` and a *to*`Config`.
         */
        public var dataflowEdges: List<List<String>>? = null
        /**
         * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.
         */
        public var minimumViableContactDurationSeconds: kotlin.Int? = null
        /**
         * Name of a mission profile.
         */
        public var name: kotlin.String? = null
        /**
         * KMS key to use for encrypting streams.
         */
        public var streamsKmsKey: aws.sdk.kotlin.services.groundstation.model.KmsKey? = null
        /**
         * Role to use for encrypting streams with KMS key.
         */
        public var streamsKmsRole: kotlin.String? = null
        /**
         * Tags assigned to a mission profile.
         */
        public var tags: Map<String, String>? = null
        /**
         * ARN of a tracking `Config`.
         */
        public var trackingConfigArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.CreateMissionProfileRequest) : this() {
            this.contactPostPassDurationSeconds = x.contactPostPassDurationSeconds
            this.contactPrePassDurationSeconds = x.contactPrePassDurationSeconds
            this.dataflowEdges = x.dataflowEdges
            this.minimumViableContactDurationSeconds = x.minimumViableContactDurationSeconds
            this.name = x.name
            this.streamsKmsKey = x.streamsKmsKey
            this.streamsKmsRole = x.streamsKmsRole
            this.tags = x.tags
            this.trackingConfigArn = x.trackingConfigArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.CreateMissionProfileRequest = CreateMissionProfileRequest(this)

        internal fun correctErrors(): Builder {
            if (dataflowEdges == null) dataflowEdges = emptyList()
            if (minimumViableContactDurationSeconds == null) minimumViableContactDurationSeconds = 0
            if (name == null) name = ""
            if (trackingConfigArn == null) trackingConfigArn = ""
            return this
        }
    }
}
