// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateEphemerisRequest private constructor(builder: Builder) {
    /**
     * Whether to set the ephemeris status to `ENABLED` after validation.
     *
     * Setting this to false will set the ephemeris status to `DISABLED` after validation.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Ephemeris data.
     */
    public val ephemeris: aws.sdk.kotlin.services.groundstation.model.EphemerisData? = builder.ephemeris
    /**
     * An overall expiration time for the ephemeris in UTC, after which it will become `EXPIRED`.
     */
    public val expirationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationTime
    /**
     * The ARN of a KMS key used to encrypt the ephemeris in Ground Station.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
     *
     * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     *
     * Priority must be 1 or greater
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * AWS Ground Station satellite ID for this ephemeris.
     */
    public val satelliteId: kotlin.String = requireNotNull(builder.satelliteId) { "A non-null value must be provided for satelliteId" }
    /**
     * Tags assigned to an ephemeris.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.CreateEphemerisRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEphemerisRequest(")
        append("enabled=$enabled,")
        append("ephemeris=$ephemeris,")
        append("expirationTime=$expirationTime,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("priority=$priority,")
        append("satelliteId=$satelliteId,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (ephemeris?.hashCode() ?: 0)
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (satelliteId.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEphemerisRequest

        if (enabled != other.enabled) return false
        if (ephemeris != other.ephemeris) return false
        if (expirationTime != other.expirationTime) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (satelliteId != other.satelliteId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.CreateEphemerisRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether to set the ephemeris status to `ENABLED` after validation.
         *
         * Setting this to false will set the ephemeris status to `DISABLED` after validation.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Ephemeris data.
         */
        public var ephemeris: aws.sdk.kotlin.services.groundstation.model.EphemerisData? = null
        /**
         * An overall expiration time for the ephemeris in UTC, after which it will become `EXPIRED`.
         */
        public var expirationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of a KMS key used to encrypt the ephemeris in Ground Station.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         */
        public var name: kotlin.String? = null
        /**
         * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
         *
         * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         *
         * Priority must be 1 or greater
         */
        public var priority: kotlin.Int? = null
        /**
         * AWS Ground Station satellite ID for this ephemeris.
         */
        public var satelliteId: kotlin.String? = null
        /**
         * Tags assigned to an ephemeris.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.CreateEphemerisRequest) : this() {
            this.enabled = x.enabled
            this.ephemeris = x.ephemeris
            this.expirationTime = x.expirationTime
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.priority = x.priority
            this.satelliteId = x.satelliteId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.CreateEphemerisRequest = CreateEphemerisRequest(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (satelliteId == null) satelliteId = ""
            return this
        }
    }
}
