// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class CreateDataflowEndpointGroupRequest private constructor(builder: Builder) {
    /**
     * Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a `POSTPASS` state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the `POSTPASS` state.
     */
    public val contactPostPassDurationSeconds: kotlin.Int? = builder.contactPostPassDurationSeconds
    /**
     * Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be in a `PREPASS` state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the `PREPASS` state.
     */
    public val contactPrePassDurationSeconds: kotlin.Int? = builder.contactPrePassDurationSeconds
    /**
     * Endpoint details of each endpoint in the dataflow endpoint group.
     */
    public val endpointDetails: List<EndpointDetails> = requireNotNull(builder.endpointDetails) { "A non-null value must be provided for endpointDetails" }
    /**
     * Tags of a dataflow endpoint group.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.CreateDataflowEndpointGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataflowEndpointGroupRequest(")
        append("contactPostPassDurationSeconds=$contactPostPassDurationSeconds,")
        append("contactPrePassDurationSeconds=$contactPrePassDurationSeconds,")
        append("endpointDetails=$endpointDetails,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactPostPassDurationSeconds ?: 0
        result = 31 * result + (contactPrePassDurationSeconds ?: 0)
        result = 31 * result + (endpointDetails.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataflowEndpointGroupRequest

        if (contactPostPassDurationSeconds != other.contactPostPassDurationSeconds) return false
        if (contactPrePassDurationSeconds != other.contactPrePassDurationSeconds) return false
        if (endpointDetails != other.endpointDetails) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.CreateDataflowEndpointGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a `POSTPASS` state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the `POSTPASS` state.
         */
        public var contactPostPassDurationSeconds: kotlin.Int? = null
        /**
         * Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be in a `PREPASS` state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the `PREPASS` state.
         */
        public var contactPrePassDurationSeconds: kotlin.Int? = null
        /**
         * Endpoint details of each endpoint in the dataflow endpoint group.
         */
        public var endpointDetails: List<EndpointDetails>? = null
        /**
         * Tags of a dataflow endpoint group.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.CreateDataflowEndpointGroupRequest) : this() {
            this.contactPostPassDurationSeconds = x.contactPostPassDurationSeconds
            this.contactPrePassDurationSeconds = x.contactPrePassDurationSeconds
            this.endpointDetails = x.endpointDetails
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.CreateDataflowEndpointGroupRequest = CreateDataflowEndpointGroupRequest(this)

        internal fun correctErrors(): Builder {
            if (endpointDetails == null) endpointDetails = emptyList()
            return this
        }
    }
}
