// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Detailed information about the agent.
 */
public class AgentDetails private constructor(builder: Builder) {
    /**
     * List of CPU cores reserved for the agent.
     */
    public val agentCpuCores: List<Int>? = builder.agentCpuCores
    /**
     * Current agent version.
     */
    public val agentVersion: kotlin.String = requireNotNull(builder.agentVersion) { "A non-null value must be provided for agentVersion" }
    /**
     * List of versions being used by agent components.
     */
    public val componentVersions: List<ComponentVersion> = requireNotNull(builder.componentVersions) { "A non-null value must be provided for componentVersions" }
    /**
     * ID of EC2 instance agent is running on.
     */
    public val instanceId: kotlin.String = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * Type of EC2 instance agent is running on.
     */
    public val instanceType: kotlin.String = requireNotNull(builder.instanceType) { "A non-null value must be provided for instanceType" }
    /**
     * This field should not be used. Use agentCpuCores instead.
     *
     * List of CPU cores reserved for processes other than the agent running on the EC2 instance.
     */
    public val reservedCpuCores: List<Int>? = builder.reservedCpuCores

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.AgentDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AgentDetails(")
        append("agentCpuCores=$agentCpuCores,")
        append("agentVersion=$agentVersion,")
        append("componentVersions=$componentVersions,")
        append("instanceId=$instanceId,")
        append("instanceType=$instanceType,")
        append("reservedCpuCores=$reservedCpuCores")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentCpuCores?.hashCode() ?: 0
        result = 31 * result + (agentVersion.hashCode())
        result = 31 * result + (componentVersions.hashCode())
        result = 31 * result + (instanceId.hashCode())
        result = 31 * result + (instanceType.hashCode())
        result = 31 * result + (reservedCpuCores?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AgentDetails

        if (agentCpuCores != other.agentCpuCores) return false
        if (agentVersion != other.agentVersion) return false
        if (componentVersions != other.componentVersions) return false
        if (instanceId != other.instanceId) return false
        if (instanceType != other.instanceType) return false
        if (reservedCpuCores != other.reservedCpuCores) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.AgentDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * List of CPU cores reserved for the agent.
         */
        public var agentCpuCores: List<Int>? = null
        /**
         * Current agent version.
         */
        public var agentVersion: kotlin.String? = null
        /**
         * List of versions being used by agent components.
         */
        public var componentVersions: List<ComponentVersion>? = null
        /**
         * ID of EC2 instance agent is running on.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Type of EC2 instance agent is running on.
         */
        public var instanceType: kotlin.String? = null
        /**
         * This field should not be used. Use agentCpuCores instead.
         *
         * List of CPU cores reserved for processes other than the agent running on the EC2 instance.
         */
        public var reservedCpuCores: List<Int>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.AgentDetails) : this() {
            this.agentCpuCores = x.agentCpuCores
            this.agentVersion = x.agentVersion
            this.componentVersions = x.componentVersions
            this.instanceId = x.instanceId
            this.instanceType = x.instanceType
            this.reservedCpuCores = x.reservedCpuCores
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.AgentDetails = AgentDetails(this)

        internal fun correctErrors(): Builder {
            if (agentVersion == null) agentVersion = ""
            if (componentVersions == null) componentVersions = emptyList()
            if (instanceId == null) instanceId = ""
            if (instanceType == null) instanceType = ""
            return this
        }
    }
}
