// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.groundstation.auth.DefaultGroundStationAuthSchemeProvider
import aws.sdk.kotlin.services.groundstation.auth.GroundStationAuthSchemeProvider
import aws.sdk.kotlin.services.groundstation.endpoints.DefaultGroundStationEndpointProvider
import aws.sdk.kotlin.services.groundstation.endpoints.GroundStationEndpointParameters
import aws.sdk.kotlin.services.groundstation.endpoints.GroundStationEndpointProvider
import aws.sdk.kotlin.services.groundstation.model.CancelContactRequest
import aws.sdk.kotlin.services.groundstation.model.CancelContactResponse
import aws.sdk.kotlin.services.groundstation.model.CreateConfigRequest
import aws.sdk.kotlin.services.groundstation.model.CreateConfigResponse
import aws.sdk.kotlin.services.groundstation.model.CreateDataflowEndpointGroupRequest
import aws.sdk.kotlin.services.groundstation.model.CreateDataflowEndpointGroupResponse
import aws.sdk.kotlin.services.groundstation.model.CreateEphemerisRequest
import aws.sdk.kotlin.services.groundstation.model.CreateEphemerisResponse
import aws.sdk.kotlin.services.groundstation.model.CreateMissionProfileRequest
import aws.sdk.kotlin.services.groundstation.model.CreateMissionProfileResponse
import aws.sdk.kotlin.services.groundstation.model.DeleteConfigRequest
import aws.sdk.kotlin.services.groundstation.model.DeleteConfigResponse
import aws.sdk.kotlin.services.groundstation.model.DeleteDataflowEndpointGroupRequest
import aws.sdk.kotlin.services.groundstation.model.DeleteDataflowEndpointGroupResponse
import aws.sdk.kotlin.services.groundstation.model.DeleteEphemerisRequest
import aws.sdk.kotlin.services.groundstation.model.DeleteEphemerisResponse
import aws.sdk.kotlin.services.groundstation.model.DeleteMissionProfileRequest
import aws.sdk.kotlin.services.groundstation.model.DeleteMissionProfileResponse
import aws.sdk.kotlin.services.groundstation.model.DescribeContactRequest
import aws.sdk.kotlin.services.groundstation.model.DescribeContactResponse
import aws.sdk.kotlin.services.groundstation.model.DescribeEphemerisRequest
import aws.sdk.kotlin.services.groundstation.model.DescribeEphemerisResponse
import aws.sdk.kotlin.services.groundstation.model.GetAgentConfigurationRequest
import aws.sdk.kotlin.services.groundstation.model.GetAgentConfigurationResponse
import aws.sdk.kotlin.services.groundstation.model.GetConfigRequest
import aws.sdk.kotlin.services.groundstation.model.GetConfigResponse
import aws.sdk.kotlin.services.groundstation.model.GetDataflowEndpointGroupRequest
import aws.sdk.kotlin.services.groundstation.model.GetDataflowEndpointGroupResponse
import aws.sdk.kotlin.services.groundstation.model.GetMinuteUsageRequest
import aws.sdk.kotlin.services.groundstation.model.GetMinuteUsageResponse
import aws.sdk.kotlin.services.groundstation.model.GetMissionProfileRequest
import aws.sdk.kotlin.services.groundstation.model.GetMissionProfileResponse
import aws.sdk.kotlin.services.groundstation.model.GetSatelliteRequest
import aws.sdk.kotlin.services.groundstation.model.GetSatelliteResponse
import aws.sdk.kotlin.services.groundstation.model.ListConfigsRequest
import aws.sdk.kotlin.services.groundstation.model.ListConfigsResponse
import aws.sdk.kotlin.services.groundstation.model.ListContactsRequest
import aws.sdk.kotlin.services.groundstation.model.ListContactsResponse
import aws.sdk.kotlin.services.groundstation.model.ListDataflowEndpointGroupsRequest
import aws.sdk.kotlin.services.groundstation.model.ListDataflowEndpointGroupsResponse
import aws.sdk.kotlin.services.groundstation.model.ListEphemeridesRequest
import aws.sdk.kotlin.services.groundstation.model.ListEphemeridesResponse
import aws.sdk.kotlin.services.groundstation.model.ListGroundStationsRequest
import aws.sdk.kotlin.services.groundstation.model.ListGroundStationsResponse
import aws.sdk.kotlin.services.groundstation.model.ListMissionProfilesRequest
import aws.sdk.kotlin.services.groundstation.model.ListMissionProfilesResponse
import aws.sdk.kotlin.services.groundstation.model.ListSatellitesRequest
import aws.sdk.kotlin.services.groundstation.model.ListSatellitesResponse
import aws.sdk.kotlin.services.groundstation.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.groundstation.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.groundstation.model.RegisterAgentRequest
import aws.sdk.kotlin.services.groundstation.model.RegisterAgentResponse
import aws.sdk.kotlin.services.groundstation.model.ReserveContactRequest
import aws.sdk.kotlin.services.groundstation.model.ReserveContactResponse
import aws.sdk.kotlin.services.groundstation.model.TagResourceRequest
import aws.sdk.kotlin.services.groundstation.model.TagResourceResponse
import aws.sdk.kotlin.services.groundstation.model.UntagResourceRequest
import aws.sdk.kotlin.services.groundstation.model.UntagResourceResponse
import aws.sdk.kotlin.services.groundstation.model.UpdateAgentStatusRequest
import aws.sdk.kotlin.services.groundstation.model.UpdateAgentStatusResponse
import aws.sdk.kotlin.services.groundstation.model.UpdateConfigRequest
import aws.sdk.kotlin.services.groundstation.model.UpdateConfigResponse
import aws.sdk.kotlin.services.groundstation.model.UpdateEphemerisRequest
import aws.sdk.kotlin.services.groundstation.model.UpdateEphemerisResponse
import aws.sdk.kotlin.services.groundstation.model.UpdateMissionProfileRequest
import aws.sdk.kotlin.services.groundstation.model.UpdateMissionProfileResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "GroundStation"
public const val SdkVersion: String = "1.2.18"
public const val ServiceApiVersion: String = "2019-05-23"

/**
 * Welcome to the AWS Ground Station API Reference. AWS Ground Station is a fully managed service that enables you to control satellite communications, downlink and process satellite data, and scale your satellite operations efficiently and cost-effectively without having to build or manage your own ground station infrastructure.
 */
public interface GroundStationClient : SdkClient {
    /**
     * GroundStationClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, GroundStationClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "GroundStation",
                "GROUNDSTATION",
                "groundstation",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, GroundStationClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): GroundStationClient = DefaultGroundStationClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: GroundStationEndpointProvider = builder.endpointProvider ?: DefaultGroundStationEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: GroundStationAuthSchemeProvider = builder.authSchemeProvider ?: DefaultGroundStationAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "GroundStation"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: GroundStationEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: GroundStationAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels a contact with a specified contact ID.
     */
    public suspend fun cancelContact(input: CancelContactRequest): CancelContactResponse

    /**
     * Creates a `Config` with the specified `configData` parameters.
     *
     * Only one type of `configData` can be specified.
     */
    public suspend fun createConfig(input: CreateConfigRequest): CreateConfigResponse

    /**
     * Creates a `DataflowEndpoint` group containing the specified list of `DataflowEndpoint` objects.
     *
     * The `name` field in each endpoint is used in your mission profile `DataflowEndpointConfig` to specify which endpoints to use during a contact.
     *
     * When a contact uses multiple `DataflowEndpointConfig` objects, each `Config` must match a `DataflowEndpoint` in the same group.
     */
    public suspend fun createDataflowEndpointGroup(input: CreateDataflowEndpointGroupRequest): CreateDataflowEndpointGroupResponse

    /**
     * Creates an Ephemeris with the specified `EphemerisData`.
     */
    public suspend fun createEphemeris(input: CreateEphemerisRequest): CreateEphemerisResponse

    /**
     * Creates a mission profile.
     *
     * `dataflowEdges` is a list of lists of strings. Each lower level list of strings has two elements: a *from* ARN and a *to* ARN.
     */
    public suspend fun createMissionProfile(input: CreateMissionProfileRequest): CreateMissionProfileResponse

    /**
     * Deletes a `Config`.
     */
    public suspend fun deleteConfig(input: DeleteConfigRequest): DeleteConfigResponse

    /**
     * Deletes a dataflow endpoint group.
     */
    public suspend fun deleteDataflowEndpointGroup(input: DeleteDataflowEndpointGroupRequest): DeleteDataflowEndpointGroupResponse

    /**
     * Deletes an ephemeris
     */
    public suspend fun deleteEphemeris(input: DeleteEphemerisRequest): DeleteEphemerisResponse

    /**
     * Deletes a mission profile.
     */
    public suspend fun deleteMissionProfile(input: DeleteMissionProfileRequest): DeleteMissionProfileResponse

    /**
     * Describes an existing contact.
     */
    public suspend fun describeContact(input: DescribeContactRequest): DescribeContactResponse

    /**
     * Describes an existing ephemeris.
     */
    public suspend fun describeEphemeris(input: DescribeEphemerisRequest): DescribeEphemerisResponse

    /**
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     *
     * Gets the latest configuration information for a registered agent.
     */
    public suspend fun getAgentConfiguration(input: GetAgentConfigurationRequest): GetAgentConfigurationResponse

    /**
     * Returns `Config` information.
     *
     * Only one `Config` response can be returned.
     */
    public suspend fun getConfig(input: GetConfigRequest): GetConfigResponse

    /**
     * Returns the dataflow endpoint group.
     */
    public suspend fun getDataflowEndpointGroup(input: GetDataflowEndpointGroupRequest): GetDataflowEndpointGroupResponse

    /**
     * Returns the number of reserved minutes used by account.
     */
    public suspend fun getMinuteUsage(input: GetMinuteUsageRequest): GetMinuteUsageResponse

    /**
     * Returns a mission profile.
     */
    public suspend fun getMissionProfile(input: GetMissionProfileRequest): GetMissionProfileResponse

    /**
     * Returns a satellite.
     */
    public suspend fun getSatellite(input: GetSatelliteRequest): GetSatelliteResponse

    /**
     * Returns a list of `Config` objects.
     */
    public suspend fun listConfigs(input: ListConfigsRequest = ListConfigsRequest { }): ListConfigsResponse

    /**
     * Returns a list of contacts.
     *
     * If `statusList` contains AVAILABLE, the request must include `groundStation`, `missionprofileArn`, and `satelliteArn`.
     */
    public suspend fun listContacts(input: ListContactsRequest): ListContactsResponse

    /**
     * Returns a list of `DataflowEndpoint` groups.
     */
    public suspend fun listDataflowEndpointGroups(input: ListDataflowEndpointGroupsRequest = ListDataflowEndpointGroupsRequest { }): ListDataflowEndpointGroupsResponse

    /**
     * List existing ephemerides.
     */
    public suspend fun listEphemerides(input: ListEphemeridesRequest): ListEphemeridesResponse

    /**
     * Returns a list of ground stations.
     */
    public suspend fun listGroundStations(input: ListGroundStationsRequest = ListGroundStationsRequest { }): ListGroundStationsResponse

    /**
     * Returns a list of mission profiles.
     */
    public suspend fun listMissionProfiles(input: ListMissionProfilesRequest = ListMissionProfilesRequest { }): ListMissionProfilesResponse

    /**
     * Returns a list of satellites.
     */
    public suspend fun listSatellites(input: ListSatellitesRequest = ListSatellitesRequest { }): ListSatellitesResponse

    /**
     * Returns a list of tags for a specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     *
     *  Registers a new agent with AWS Ground Station.
     */
    public suspend fun registerAgent(input: RegisterAgentRequest): RegisterAgentResponse

    /**
     * Reserves a contact using specified parameters.
     */
    public suspend fun reserveContact(input: ReserveContactRequest): ReserveContactResponse

    /**
     * Assigns a tag to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deassigns a resource tag.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     *
     * Update the status of the agent.
     */
    public suspend fun updateAgentStatus(input: UpdateAgentStatusRequest): UpdateAgentStatusResponse

    /**
     * Updates the `Config` used when scheduling contacts.
     *
     * Updating a `Config` will not update the execution parameters for existing future contacts scheduled with this `Config`.
     */
    public suspend fun updateConfig(input: UpdateConfigRequest): UpdateConfigResponse

    /**
     * Updates an existing ephemeris
     */
    public suspend fun updateEphemeris(input: UpdateEphemerisRequest): UpdateEphemerisResponse

    /**
     * Updates a mission profile.
     *
     * Updating a mission profile will not update the execution parameters for existing future contacts.
     */
    public suspend fun updateMissionProfile(input: UpdateMissionProfileRequest): UpdateMissionProfileResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun GroundStationClient.withConfig(block: GroundStationClient.Config.Builder.() -> Unit): GroundStationClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultGroundStationClient(newConfig)
}

/**
 * Cancels a contact with a specified contact ID.
 */
public suspend inline fun GroundStationClient.cancelContact(crossinline block: CancelContactRequest.Builder.() -> Unit): CancelContactResponse = cancelContact(CancelContactRequest.Builder().apply(block).build())

/**
 * Creates a `Config` with the specified `configData` parameters.
 *
 * Only one type of `configData` can be specified.
 */
public suspend inline fun GroundStationClient.createConfig(crossinline block: CreateConfigRequest.Builder.() -> Unit): CreateConfigResponse = createConfig(CreateConfigRequest.Builder().apply(block).build())

/**
 * Creates a `DataflowEndpoint` group containing the specified list of `DataflowEndpoint` objects.
 *
 * The `name` field in each endpoint is used in your mission profile `DataflowEndpointConfig` to specify which endpoints to use during a contact.
 *
 * When a contact uses multiple `DataflowEndpointConfig` objects, each `Config` must match a `DataflowEndpoint` in the same group.
 */
public suspend inline fun GroundStationClient.createDataflowEndpointGroup(crossinline block: CreateDataflowEndpointGroupRequest.Builder.() -> Unit): CreateDataflowEndpointGroupResponse = createDataflowEndpointGroup(CreateDataflowEndpointGroupRequest.Builder().apply(block).build())

/**
 * Creates an Ephemeris with the specified `EphemerisData`.
 */
public suspend inline fun GroundStationClient.createEphemeris(crossinline block: CreateEphemerisRequest.Builder.() -> Unit): CreateEphemerisResponse = createEphemeris(CreateEphemerisRequest.Builder().apply(block).build())

/**
 * Creates a mission profile.
 *
 * `dataflowEdges` is a list of lists of strings. Each lower level list of strings has two elements: a *from* ARN and a *to* ARN.
 */
public suspend inline fun GroundStationClient.createMissionProfile(crossinline block: CreateMissionProfileRequest.Builder.() -> Unit): CreateMissionProfileResponse = createMissionProfile(CreateMissionProfileRequest.Builder().apply(block).build())

/**
 * Deletes a `Config`.
 */
public suspend inline fun GroundStationClient.deleteConfig(crossinline block: DeleteConfigRequest.Builder.() -> Unit): DeleteConfigResponse = deleteConfig(DeleteConfigRequest.Builder().apply(block).build())

/**
 * Deletes a dataflow endpoint group.
 */
public suspend inline fun GroundStationClient.deleteDataflowEndpointGroup(crossinline block: DeleteDataflowEndpointGroupRequest.Builder.() -> Unit): DeleteDataflowEndpointGroupResponse = deleteDataflowEndpointGroup(DeleteDataflowEndpointGroupRequest.Builder().apply(block).build())

/**
 * Deletes an ephemeris
 */
public suspend inline fun GroundStationClient.deleteEphemeris(crossinline block: DeleteEphemerisRequest.Builder.() -> Unit): DeleteEphemerisResponse = deleteEphemeris(DeleteEphemerisRequest.Builder().apply(block).build())

/**
 * Deletes a mission profile.
 */
public suspend inline fun GroundStationClient.deleteMissionProfile(crossinline block: DeleteMissionProfileRequest.Builder.() -> Unit): DeleteMissionProfileResponse = deleteMissionProfile(DeleteMissionProfileRequest.Builder().apply(block).build())

/**
 * Describes an existing contact.
 */
public suspend inline fun GroundStationClient.describeContact(crossinline block: DescribeContactRequest.Builder.() -> Unit): DescribeContactResponse = describeContact(DescribeContactRequest.Builder().apply(block).build())

/**
 * Describes an existing ephemeris.
 */
public suspend inline fun GroundStationClient.describeEphemeris(crossinline block: DescribeEphemerisRequest.Builder.() -> Unit): DescribeEphemerisResponse = describeEphemeris(DescribeEphemerisRequest.Builder().apply(block).build())

/**
 * For use by AWS Ground Station Agent and shouldn't be called directly.
 *
 * Gets the latest configuration information for a registered agent.
 */
public suspend inline fun GroundStationClient.getAgentConfiguration(crossinline block: GetAgentConfigurationRequest.Builder.() -> Unit): GetAgentConfigurationResponse = getAgentConfiguration(GetAgentConfigurationRequest.Builder().apply(block).build())

/**
 * Returns `Config` information.
 *
 * Only one `Config` response can be returned.
 */
public suspend inline fun GroundStationClient.getConfig(crossinline block: GetConfigRequest.Builder.() -> Unit): GetConfigResponse = getConfig(GetConfigRequest.Builder().apply(block).build())

/**
 * Returns the dataflow endpoint group.
 */
public suspend inline fun GroundStationClient.getDataflowEndpointGroup(crossinline block: GetDataflowEndpointGroupRequest.Builder.() -> Unit): GetDataflowEndpointGroupResponse = getDataflowEndpointGroup(GetDataflowEndpointGroupRequest.Builder().apply(block).build())

/**
 * Returns the number of reserved minutes used by account.
 */
public suspend inline fun GroundStationClient.getMinuteUsage(crossinline block: GetMinuteUsageRequest.Builder.() -> Unit): GetMinuteUsageResponse = getMinuteUsage(GetMinuteUsageRequest.Builder().apply(block).build())

/**
 * Returns a mission profile.
 */
public suspend inline fun GroundStationClient.getMissionProfile(crossinline block: GetMissionProfileRequest.Builder.() -> Unit): GetMissionProfileResponse = getMissionProfile(GetMissionProfileRequest.Builder().apply(block).build())

/**
 * Returns a satellite.
 */
public suspend inline fun GroundStationClient.getSatellite(crossinline block: GetSatelliteRequest.Builder.() -> Unit): GetSatelliteResponse = getSatellite(GetSatelliteRequest.Builder().apply(block).build())

/**
 * Returns a list of `Config` objects.
 */
public suspend inline fun GroundStationClient.listConfigs(crossinline block: ListConfigsRequest.Builder.() -> Unit): ListConfigsResponse = listConfigs(ListConfigsRequest.Builder().apply(block).build())

/**
 * Returns a list of contacts.
 *
 * If `statusList` contains AVAILABLE, the request must include `groundStation`, `missionprofileArn`, and `satelliteArn`.
 */
public suspend inline fun GroundStationClient.listContacts(crossinline block: ListContactsRequest.Builder.() -> Unit): ListContactsResponse = listContacts(ListContactsRequest.Builder().apply(block).build())

/**
 * Returns a list of `DataflowEndpoint` groups.
 */
public suspend inline fun GroundStationClient.listDataflowEndpointGroups(crossinline block: ListDataflowEndpointGroupsRequest.Builder.() -> Unit): ListDataflowEndpointGroupsResponse = listDataflowEndpointGroups(ListDataflowEndpointGroupsRequest.Builder().apply(block).build())

/**
 * List existing ephemerides.
 */
public suspend inline fun GroundStationClient.listEphemerides(crossinline block: ListEphemeridesRequest.Builder.() -> Unit): ListEphemeridesResponse = listEphemerides(ListEphemeridesRequest.Builder().apply(block).build())

/**
 * Returns a list of ground stations.
 */
public suspend inline fun GroundStationClient.listGroundStations(crossinline block: ListGroundStationsRequest.Builder.() -> Unit): ListGroundStationsResponse = listGroundStations(ListGroundStationsRequest.Builder().apply(block).build())

/**
 * Returns a list of mission profiles.
 */
public suspend inline fun GroundStationClient.listMissionProfiles(crossinline block: ListMissionProfilesRequest.Builder.() -> Unit): ListMissionProfilesResponse = listMissionProfiles(ListMissionProfilesRequest.Builder().apply(block).build())

/**
 * Returns a list of satellites.
 */
public suspend inline fun GroundStationClient.listSatellites(crossinline block: ListSatellitesRequest.Builder.() -> Unit): ListSatellitesResponse = listSatellites(ListSatellitesRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for a specified resource.
 */
public suspend inline fun GroundStationClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * For use by AWS Ground Station Agent and shouldn't be called directly.
 *
 *  Registers a new agent with AWS Ground Station.
 */
public suspend inline fun GroundStationClient.registerAgent(crossinline block: RegisterAgentRequest.Builder.() -> Unit): RegisterAgentResponse = registerAgent(RegisterAgentRequest.Builder().apply(block).build())

/**
 * Reserves a contact using specified parameters.
 */
public suspend inline fun GroundStationClient.reserveContact(crossinline block: ReserveContactRequest.Builder.() -> Unit): ReserveContactResponse = reserveContact(ReserveContactRequest.Builder().apply(block).build())

/**
 * Assigns a tag to a resource.
 */
public suspend inline fun GroundStationClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deassigns a resource tag.
 */
public suspend inline fun GroundStationClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * For use by AWS Ground Station Agent and shouldn't be called directly.
 *
 * Update the status of the agent.
 */
public suspend inline fun GroundStationClient.updateAgentStatus(crossinline block: UpdateAgentStatusRequest.Builder.() -> Unit): UpdateAgentStatusResponse = updateAgentStatus(UpdateAgentStatusRequest.Builder().apply(block).build())

/**
 * Updates the `Config` used when scheduling contacts.
 *
 * Updating a `Config` will not update the execution parameters for existing future contacts scheduled with this `Config`.
 */
public suspend inline fun GroundStationClient.updateConfig(crossinline block: UpdateConfigRequest.Builder.() -> Unit): UpdateConfigResponse = updateConfig(UpdateConfigRequest.Builder().apply(block).build())

/**
 * Updates an existing ephemeris
 */
public suspend inline fun GroundStationClient.updateEphemeris(crossinline block: UpdateEphemerisRequest.Builder.() -> Unit): UpdateEphemerisResponse = updateEphemeris(UpdateEphemerisRequest.Builder().apply(block).build())

/**
 * Updates a mission profile.
 *
 * Updating a mission profile will not update the execution parameters for existing future contacts.
 */
public suspend inline fun GroundStationClient.updateMissionProfile(crossinline block: UpdateMissionProfileRequest.Builder.() -> Unit): UpdateMissionProfileResponse = updateMissionProfile(UpdateMissionProfileRequest.Builder().apply(block).build())
