// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.greengrassv2.model.GreengrassV2Exception
import aws.sdk.kotlin.services.greengrassv2.model.ResolveComponentCandidatesResponse
import aws.sdk.kotlin.services.greengrassv2.model.ResolvedComponentVersion
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ResolveComponentCandidatesOperationDeserializer: HttpDeserialize<ResolveComponentCandidatesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ResolveComponentCandidatesResponse {
        if (!response.status.isSuccess()) {
            throwResolveComponentCandidatesError(context, response)
        }
        val builder = ResolveComponentCandidatesResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeResolveComponentCandidatesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeResolveComponentCandidatesOperationBody(builder: ResolveComponentCandidatesResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESOLVEDCOMPONENTVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("resolvedComponentVersions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOLVEDCOMPONENTVERSIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESOLVEDCOMPONENTVERSIONS_DESCRIPTOR.index -> builder.resolvedComponentVersions =
                    deserializer.deserializeList(RESOLVEDCOMPONENTVERSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ResolvedComponentVersion>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResolvedComponentVersionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwResolveComponentCandidatesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw GreengrassV2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
