// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.greengrassv2.model.ComponentDeploymentSpecification
import aws.sdk.kotlin.services.greengrassv2.model.DeploymentStatus
import aws.sdk.kotlin.services.greengrassv2.model.GetDeploymentResponse
import aws.sdk.kotlin.services.greengrassv2.model.GreengrassV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetDeploymentOperationDeserializer: HttpDeserialize<GetDeploymentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDeploymentResponse {
        if (!response.status.isSuccess()) {
            throwGetDeploymentError(context, response)
        }
        val builder = GetDeploymentResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDeploymentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetDeploymentOperationBody(builder: GetDeploymentResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPONENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("components"))
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTimestamp"))
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val DEPLOYMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentName"))
    val DEPLOYMENTPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deploymentPolicies"))
    val DEPLOYMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentStatus"))
    val IOTJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("iotJobArn"))
    val IOTJOBCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("iotJobConfiguration"))
    val IOTJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("iotJobId"))
    val ISLATESTFORTARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isLatestForTarget"))
    val REVISIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("revisionId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TARGETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTS_DESCRIPTOR)
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(DEPLOYMENTID_DESCRIPTOR)
        field(DEPLOYMENTNAME_DESCRIPTOR)
        field(DEPLOYMENTPOLICIES_DESCRIPTOR)
        field(DEPLOYMENTSTATUS_DESCRIPTOR)
        field(IOTJOBARN_DESCRIPTOR)
        field(IOTJOBCONFIGURATION_DESCRIPTOR)
        field(IOTJOBID_DESCRIPTOR)
        field(ISLATESTFORTARGET_DESCRIPTOR)
        field(REVISIONID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPONENTS_DESCRIPTOR.index -> builder.components =
                    deserializer.deserializeMap(COMPONENTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, ComponentDeploymentSpecification>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeComponentDeploymentSpecificationDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEPLOYMENTID_DESCRIPTOR.index -> builder.deploymentId = deserializeString()
                DEPLOYMENTNAME_DESCRIPTOR.index -> builder.deploymentName = deserializeString()
                DEPLOYMENTPOLICIES_DESCRIPTOR.index -> builder.deploymentPolicies = deserializeDeploymentPoliciesDocument(deserializer)
                DEPLOYMENTSTATUS_DESCRIPTOR.index -> builder.deploymentStatus = deserializeString().let { DeploymentStatus.fromValue(it) }
                IOTJOBARN_DESCRIPTOR.index -> builder.iotJobArn = deserializeString()
                IOTJOBCONFIGURATION_DESCRIPTOR.index -> builder.iotJobConfiguration = deserializeDeploymentIoTJobConfigurationDocument(deserializer)
                IOTJOBID_DESCRIPTOR.index -> builder.iotJobId = deserializeString()
                ISLATESTFORTARGET_DESCRIPTOR.index -> builder.isLatestForTarget = deserializeBoolean()
                REVISIONID_DESCRIPTOR.index -> builder.revisionId = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TARGETARN_DESCRIPTOR.index -> builder.targetArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetDeploymentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw GreengrassV2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
