// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Your request exceeded a request rate quota. For example, you might have exceeded the
 * amount of times that you can retrieve device or deployment status per second.
 */
class ThrottlingException private constructor(builder: BuilderImpl) : GreengrassV2Exception() {

    override val message: String? = builder.message
    /**
     * The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
     */
    val quotaCode: String? = builder.quotaCode
    /**
     * The amount of time to wait before you retry the request.
     */
    val retryAfterSeconds: Int = builder.retryAfterSeconds
    /**
     * The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
     */
    val serviceCode: String? = builder.serviceCode

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ThrottlingException = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ThrottlingException(")
        append("message=$message,")
        append("quotaCode=$quotaCode,")
        append("retryAfterSeconds=$retryAfterSeconds,")
        append("serviceCode=$serviceCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (quotaCode?.hashCode() ?: 0)
        result = 31 * result + (retryAfterSeconds)
        result = 31 * result + (serviceCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ThrottlingException

        if (message != other.message) return false
        if (quotaCode != other.quotaCode) return false
        if (retryAfterSeconds != other.retryAfterSeconds) return false
        if (serviceCode != other.serviceCode) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ThrottlingException = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ThrottlingException
        fun message(message: String): FluentBuilder
        /**
         * The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
         */
        fun quotaCode(quotaCode: String): FluentBuilder
        /**
         * The amount of time to wait before you retry the request.
         */
        fun retryAfterSeconds(retryAfterSeconds: Int): FluentBuilder
        /**
         * The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
         */
        fun serviceCode(serviceCode: String): FluentBuilder
    }

    interface DslBuilder {
        var message: String?
        /**
         * The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
         */
        var quotaCode: String?
        /**
         * The amount of time to wait before you retry the request.
         */
        var retryAfterSeconds: Int
        /**
         * The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
         */
        var serviceCode: String?

        fun build(): ThrottlingException
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var message: String? = null
        override var quotaCode: String? = null
        override var retryAfterSeconds: Int = 0
        override var serviceCode: String? = null

        constructor(x: ThrottlingException) : this() {
            this.message = x.message
            this.quotaCode = x.quotaCode
            this.retryAfterSeconds = x.retryAfterSeconds
            this.serviceCode = x.serviceCode
        }

        override fun build(): ThrottlingException = ThrottlingException(this)
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun quotaCode(quotaCode: String): FluentBuilder = apply { this.quotaCode = quotaCode }
        override fun retryAfterSeconds(retryAfterSeconds: Int): FluentBuilder = apply { this.retryAfterSeconds = retryAfterSeconds }
        override fun serviceCode(serviceCode: String): FluentBuilder = apply { this.serviceCode = serviceCode }
    }
}
