// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about system resource limits that the IoT Greengrass Core software applies to a
 * component's processes. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components.
 */
class SystemResourceLimits private constructor(builder: BuilderImpl) {
    /**
     * The maximum amount of CPU time that a component's processes can use on the core device. A
     * core device's total CPU time is equivalent to the device's number of CPU cores. For example,
     * on a core device with 4 CPU cores, you can set this value to 2 to limit the
     * component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you
     * can set this value to 0.25 to limit the component's processes to 25 percent usage
     * of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT Greengrass Core
     * software doesn't limit the component's CPU usage.
     */
    val cpus: Double = builder.cpus
    /**
     * The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on
     * the core device.
     */
    val memory: Long = builder.memory

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SystemResourceLimits = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SystemResourceLimits(")
        append("cpus=$cpus,")
        append("memory=$memory)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpus.hashCode()
        result = 31 * result + (memory.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SystemResourceLimits

        if (cpus != other.cpus) return false
        if (memory != other.memory) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SystemResourceLimits = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SystemResourceLimits
        /**
         * The maximum amount of CPU time that a component's processes can use on the core device. A
         * core device's total CPU time is equivalent to the device's number of CPU cores. For example,
         * on a core device with 4 CPU cores, you can set this value to 2 to limit the
         * component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you
         * can set this value to 0.25 to limit the component's processes to 25 percent usage
         * of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT Greengrass Core
         * software doesn't limit the component's CPU usage.
         */
        fun cpus(cpus: Double): FluentBuilder
        /**
         * The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on
         * the core device.
         */
        fun memory(memory: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum amount of CPU time that a component's processes can use on the core device. A
         * core device's total CPU time is equivalent to the device's number of CPU cores. For example,
         * on a core device with 4 CPU cores, you can set this value to 2 to limit the
         * component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you
         * can set this value to 0.25 to limit the component's processes to 25 percent usage
         * of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT Greengrass Core
         * software doesn't limit the component's CPU usage.
         */
        var cpus: Double
        /**
         * The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on
         * the core device.
         */
        var memory: Long

        fun build(): SystemResourceLimits
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cpus: Double = 0.0
        override var memory: Long = 0L

        constructor(x: SystemResourceLimits) : this() {
            this.cpus = x.cpus
            this.memory = x.memory
        }

        override fun build(): SystemResourceLimits = SystemResourceLimits(this)
        override fun cpus(cpus: Double): FluentBuilder = apply { this.cpus = cpus }
        override fun memory(memory: Long): FluentBuilder = apply { this.memory = memory }
    }
}
