// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Your request exceeds a service quota. For example, you might have the maximum number of
 * components that you can create.
 */
class ServiceQuotaExceededException private constructor(builder: BuilderImpl) : GreengrassV2Exception() {

    override val message: String? = builder.message
    /**
     * The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
     */
    val quotaCode: String? = builder.quotaCode
    /**
     * The ID of the resource that exceeds the service quota.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The type of the resource that exceeds the service quota.
     */
    val resourceType: String? = builder.resourceType
    /**
     * The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
     */
    val serviceCode: String? = builder.serviceCode

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ServiceQuotaExceededException = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceQuotaExceededException(")
        append("message=$message,")
        append("quotaCode=$quotaCode,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("serviceCode=$serviceCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (quotaCode?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (serviceCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ServiceQuotaExceededException

        if (message != other.message) return false
        if (quotaCode != other.quotaCode) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (serviceCode != other.serviceCode) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ServiceQuotaExceededException = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ServiceQuotaExceededException
        fun message(message: String): FluentBuilder
        /**
         * The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
         */
        fun quotaCode(quotaCode: String): FluentBuilder
        /**
         * The ID of the resource that exceeds the service quota.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The type of the resource that exceeds the service quota.
         */
        fun resourceType(resourceType: String): FluentBuilder
        /**
         * The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
         */
        fun serviceCode(serviceCode: String): FluentBuilder
    }

    interface DslBuilder {
        var message: String?
        /**
         * The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
         */
        var quotaCode: String?
        /**
         * The ID of the resource that exceeds the service quota.
         */
        var resourceId: String?
        /**
         * The type of the resource that exceeds the service quota.
         */
        var resourceType: String?
        /**
         * The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas.
         */
        var serviceCode: String?

        fun build(): ServiceQuotaExceededException
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var message: String? = null
        override var quotaCode: String? = null
        override var resourceId: String? = null
        override var resourceType: String? = null
        override var serviceCode: String? = null

        constructor(x: ServiceQuotaExceededException) : this() {
            this.message = x.message
            this.quotaCode = x.quotaCode
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.serviceCode = x.serviceCode
        }

        override fun build(): ServiceQuotaExceededException = ServiceQuotaExceededException(this)
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun quotaCode(quotaCode: String): FluentBuilder = apply { this.quotaCode = quotaCode }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun resourceType(resourceType: String): FluentBuilder = apply { this.resourceType = resourceType }
        override fun serviceCode(serviceCode: String): FluentBuilder = apply { this.serviceCode = serviceCode }
    }
}
