// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a component version that is compatible to run on a Greengrass core
 * device.
 */
class ResolvedComponentVersion private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
     */
    val arn: String? = builder.arn
    /**
     * The name of the component.
     */
    val componentName: String? = builder.componentName
    /**
     * The version of the component.
     */
    val componentVersion: String? = builder.componentVersion
    /**
     * The recipe of the component version.
     */
    val recipe: ByteArray? = builder.recipe

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ResolvedComponentVersion = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ResolvedComponentVersion(")
        append("arn=$arn,")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("recipe=$recipe)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (recipe?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ResolvedComponentVersion

        if (arn != other.arn) return false
        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (recipe != null) {
            if (other.recipe == null) return false
            if (!recipe.contentEquals(other.recipe)) return false
        } else if (other.recipe != null) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ResolvedComponentVersion = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ResolvedComponentVersion
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun componentName(componentName: String): FluentBuilder
        /**
         * The version of the component.
         */
        fun componentVersion(componentVersion: String): FluentBuilder
        /**
         * The recipe of the component version.
         */
        fun recipe(recipe: ByteArray): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        var arn: String?
        /**
         * The name of the component.
         */
        var componentName: String?
        /**
         * The version of the component.
         */
        var componentVersion: String?
        /**
         * The recipe of the component version.
         */
        var recipe: ByteArray?

        fun build(): ResolvedComponentVersion
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var componentName: String? = null
        override var componentVersion: String? = null
        override var recipe: ByteArray? = null

        constructor(x: ResolvedComponentVersion) : this() {
            this.arn = x.arn
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.recipe = x.recipe
        }

        override fun build(): ResolvedComponentVersion = ResolvedComponentVersion(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun componentName(componentName: String): FluentBuilder = apply { this.componentName = componentName }
        override fun componentVersion(componentVersion: String): FluentBuilder = apply { this.componentVersion = componentVersion }
        override fun recipe(recipe: ByteArray): FluentBuilder = apply { this.recipe = recipe }
    }
}
