// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



class ListDeploymentsRequest private constructor(builder: BuilderImpl) {
    /**
     * The filter for the list of deployments. Choose one of the following options:
     * ALL – The list includes all deployments.
     * LATEST_ONLY – The list includes only the latest revision of each
     * deployment.
     * Default: LATEST_ONLY
     */
    val historyFilter: DeploymentHistoryFilter? = builder.historyFilter
    /**
     * The maximum number of results to be returned per paginated request.
     */
    val maxResults: Int = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
     */
    val targetArn: String? = builder.targetArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListDeploymentsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListDeploymentsRequest(")
        append("historyFilter=$historyFilter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = historyFilter?.hashCode() ?: 0
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListDeploymentsRequest

        if (historyFilter != other.historyFilter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListDeploymentsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListDeploymentsRequest
        /**
         * The filter for the list of deployments. Choose one of the following options:
         * ALL – The list includes all deployments.
         * LATEST_ONLY – The list includes only the latest revision of each
         * deployment.
         * Default: LATEST_ONLY
         */
        fun historyFilter(historyFilter: DeploymentHistoryFilter): FluentBuilder
        /**
         * The maximum number of results to be returned per paginated request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to be used for the next set of paginated results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        fun targetArn(targetArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The filter for the list of deployments. Choose one of the following options:
         * ALL – The list includes all deployments.
         * LATEST_ONLY – The list includes only the latest revision of each
         * deployment.
         * Default: LATEST_ONLY
         */
        var historyFilter: DeploymentHistoryFilter?
        /**
         * The maximum number of results to be returned per paginated request.
         */
        var maxResults: Int
        /**
         * The token to be used for the next set of paginated results.
         */
        var nextToken: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        var targetArn: String?

        fun build(): ListDeploymentsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var historyFilter: DeploymentHistoryFilter? = null
        override var maxResults: Int = 0
        override var nextToken: String? = null
        override var targetArn: String? = null

        constructor(x: ListDeploymentsRequest) : this() {
            this.historyFilter = x.historyFilter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.targetArn = x.targetArn
        }

        override fun build(): ListDeploymentsRequest = ListDeploymentsRequest(this)
        override fun historyFilter(historyFilter: DeploymentHistoryFilter): FluentBuilder = apply { this.historyFilter = historyFilter }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
    }
}
