// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



class ListCoreDevicesRequest private constructor(builder: BuilderImpl) {
    /**
     * The maximum number of results to be returned per paginated request.
     */
    val maxResults: Int = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The core device status by which to filter. If you specify this parameter, the list
     * includes only core devices that have this status. Choose one of the following options:
     * HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.
     * UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state
     * on the core device.
     */
    val status: CoreDeviceStatus? = builder.status
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IoT thing group by which to filter. If you specify this parameter, the
     * list includes only core devices that are members of this thing group.
     */
    val thingGroupArn: String? = builder.thingGroupArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListCoreDevicesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListCoreDevicesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("status=$status,")
        append("thingGroupArn=$thingGroupArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (thingGroupArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListCoreDevicesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false
        if (thingGroupArn != other.thingGroupArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListCoreDevicesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListCoreDevicesRequest
        /**
         * The maximum number of results to be returned per paginated request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to be used for the next set of paginated results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The core device status by which to filter. If you specify this parameter, the list
         * includes only core devices that have this status. Choose one of the following options:
         * HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.
         * UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state
         * on the core device.
         */
        fun status(status: CoreDeviceStatus): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IoT thing group by which to filter. If you specify this parameter, the
         * list includes only core devices that are members of this thing group.
         */
        fun thingGroupArn(thingGroupArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum number of results to be returned per paginated request.
         */
        var maxResults: Int
        /**
         * The token to be used for the next set of paginated results.
         */
        var nextToken: String?
        /**
         * The core device status by which to filter. If you specify this parameter, the list
         * includes only core devices that have this status. Choose one of the following options:
         * HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.
         * UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state
         * on the core device.
         */
        var status: CoreDeviceStatus?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IoT thing group by which to filter. If you specify this parameter, the
         * list includes only core devices that are members of this thing group.
         */
        var thingGroupArn: String?

        fun build(): ListCoreDevicesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var maxResults: Int = 0
        override var nextToken: String? = null
        override var status: CoreDeviceStatus? = null
        override var thingGroupArn: String? = null

        constructor(x: ListCoreDevicesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.status = x.status
            this.thingGroupArn = x.thingGroupArn
        }

        override fun build(): ListCoreDevicesRequest = ListCoreDevicesRequest(this)
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun status(status: CoreDeviceStatus): FluentBuilder = apply { this.status = status }
        override fun thingGroupArn(thingGroupArn: String): FluentBuilder = apply { this.thingGroupArn = thingGroupArn }
    }
}
