// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a volume that Linux processes in a container can access. When
 * you define a volume, the IoT Greengrass Core software mounts the source files to the destination inside the
 * container.
 */
class LambdaVolumeMount private constructor(builder: BuilderImpl) {
    /**
     * Whether or not to add the IoT Greengrass user group as an owner of the volume.
     * Default: false
     */
    val addGroupOwner: Boolean = builder.addGroupOwner
    /**
     * The path to the logical volume in the file system.
     */
    val destinationPath: String? = builder.destinationPath
    /**
     * The permission to access the volume: read/only (ro) or read/write
     * (rw).
     * Default: ro
     */
    val permission: LambdaFilesystemPermission? = builder.permission
    /**
     * The path to the physical volume in the file system.
     */
    val sourcePath: String? = builder.sourcePath

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaVolumeMount = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaVolumeMount(")
        append("addGroupOwner=$addGroupOwner,")
        append("destinationPath=$destinationPath,")
        append("permission=$permission,")
        append("sourcePath=$sourcePath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addGroupOwner.hashCode()
        result = 31 * result + (destinationPath?.hashCode() ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        result = 31 * result + (sourcePath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaVolumeMount

        if (addGroupOwner != other.addGroupOwner) return false
        if (destinationPath != other.destinationPath) return false
        if (permission != other.permission) return false
        if (sourcePath != other.sourcePath) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaVolumeMount = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaVolumeMount
        /**
         * Whether or not to add the IoT Greengrass user group as an owner of the volume.
         * Default: false
         */
        fun addGroupOwner(addGroupOwner: Boolean): FluentBuilder
        /**
         * The path to the logical volume in the file system.
         */
        fun destinationPath(destinationPath: String): FluentBuilder
        /**
         * The permission to access the volume: read/only (ro) or read/write
         * (rw).
         * Default: ro
         */
        fun permission(permission: LambdaFilesystemPermission): FluentBuilder
        /**
         * The path to the physical volume in the file system.
         */
        fun sourcePath(sourcePath: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Whether or not to add the IoT Greengrass user group as an owner of the volume.
         * Default: false
         */
        var addGroupOwner: Boolean
        /**
         * The path to the logical volume in the file system.
         */
        var destinationPath: String?
        /**
         * The permission to access the volume: read/only (ro) or read/write
         * (rw).
         * Default: ro
         */
        var permission: LambdaFilesystemPermission?
        /**
         * The path to the physical volume in the file system.
         */
        var sourcePath: String?

        fun build(): LambdaVolumeMount
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var addGroupOwner: Boolean = false
        override var destinationPath: String? = null
        override var permission: LambdaFilesystemPermission? = null
        override var sourcePath: String? = null

        constructor(x: LambdaVolumeMount) : this() {
            this.addGroupOwner = x.addGroupOwner
            this.destinationPath = x.destinationPath
            this.permission = x.permission
            this.sourcePath = x.sourcePath
        }

        override fun build(): LambdaVolumeMount = LambdaVolumeMount(this)
        override fun addGroupOwner(addGroupOwner: Boolean): FluentBuilder = apply { this.addGroupOwner = addGroupOwner }
        override fun destinationPath(destinationPath: String): FluentBuilder = apply { this.destinationPath = destinationPath }
        override fun permission(permission: LambdaFilesystemPermission): FluentBuilder = apply { this.permission = permission }
        override fun sourcePath(sourcePath: String): FluentBuilder = apply { this.sourcePath = sourcePath }
    }
}
