// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains parameters for a Linux process that contains an Lambda function.
 */
class LambdaLinuxProcessParams private constructor(builder: BuilderImpl) {
    /**
     * The parameters for the container in which the Lambda function runs.
     */
    val containerParams: LambdaContainerParams? = builder.containerParams
    /**
     * The isolation mode for the process that contains the Lambda function. The process can run
     * in an isolated runtime environment inside the IoT Greengrass container, or as a regular process outside
     * any container.
     * Default: GreengrassContainer
     */
    val isolationMode: LambdaIsolationMode? = builder.isolationMode

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaLinuxProcessParams = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaLinuxProcessParams(")
        append("containerParams=$containerParams,")
        append("isolationMode=$isolationMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerParams?.hashCode() ?: 0
        result = 31 * result + (isolationMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaLinuxProcessParams

        if (containerParams != other.containerParams) return false
        if (isolationMode != other.isolationMode) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaLinuxProcessParams = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaLinuxProcessParams
        /**
         * The parameters for the container in which the Lambda function runs.
         */
        fun containerParams(containerParams: LambdaContainerParams): FluentBuilder
        /**
         * The isolation mode for the process that contains the Lambda function. The process can run
         * in an isolated runtime environment inside the IoT Greengrass container, or as a regular process outside
         * any container.
         * Default: GreengrassContainer
         */
        fun isolationMode(isolationMode: LambdaIsolationMode): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The parameters for the container in which the Lambda function runs.
         */
        var containerParams: LambdaContainerParams?
        /**
         * The isolation mode for the process that contains the Lambda function. The process can run
         * in an isolated runtime environment inside the IoT Greengrass container, or as a regular process outside
         * any container.
         * Default: GreengrassContainer
         */
        var isolationMode: LambdaIsolationMode?

        fun build(): LambdaLinuxProcessParams
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.LambdaContainerParams] inside the given [block]
         */
        fun containerParams(block: LambdaContainerParams.DslBuilder.() -> kotlin.Unit) {
            this.containerParams = LambdaContainerParams.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var containerParams: LambdaContainerParams? = null
        override var isolationMode: LambdaIsolationMode? = null

        constructor(x: LambdaLinuxProcessParams) : this() {
            this.containerParams = x.containerParams
            this.isolationMode = x.isolationMode
        }

        override fun build(): LambdaLinuxProcessParams = LambdaLinuxProcessParams(this)
        override fun containerParams(containerParams: LambdaContainerParams): FluentBuilder = apply { this.containerParams = containerParams }
        override fun isolationMode(isolationMode: LambdaIsolationMode): FluentBuilder = apply { this.isolationMode = isolationMode }
    }
}
