// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about an Lambda function to import to create a component.
 */
class LambdaFunctionRecipeSource private constructor(builder: BuilderImpl) {
    /**
     * The component versions on which this Lambda function component depends.
     */
    val componentDependencies: Map<String, ComponentDependencyRequirement>? = builder.componentDependencies
    /**
     * The system and runtime parameters for the Lambda function as it runs on the Greengrass core
     * device.
     */
    val componentLambdaParameters: LambdaExecutionParameters? = builder.componentLambdaParameters
    /**
     * The name of the component.
     * Defaults to the name of the Lambda function.
     */
    val componentName: String? = builder.componentName
    /**
     * The platforms that the component version supports.
     */
    val componentPlatforms: List<ComponentPlatform>? = builder.componentPlatforms
    /**
     * The version of the component.
     * Defaults to the version of the Lambda function as a semantic version. For example, if your
     * function version is 3, the component version becomes 3.0.0.
     */
    val componentVersion: String? = builder.componentVersion
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Lambda function. The ARN must include the version of the function to
     * import. You can't use version aliases like $LATEST.
     */
    val lambdaArn: String? = builder.lambdaArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaFunctionRecipeSource = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionRecipeSource(")
        append("componentDependencies=$componentDependencies,")
        append("componentLambdaParameters=$componentLambdaParameters,")
        append("componentName=$componentName,")
        append("componentPlatforms=$componentPlatforms,")
        append("componentVersion=$componentVersion,")
        append("lambdaArn=$lambdaArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentDependencies?.hashCode() ?: 0
        result = 31 * result + (componentLambdaParameters?.hashCode() ?: 0)
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (componentPlatforms?.hashCode() ?: 0)
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (lambdaArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaFunctionRecipeSource

        if (componentDependencies != other.componentDependencies) return false
        if (componentLambdaParameters != other.componentLambdaParameters) return false
        if (componentName != other.componentName) return false
        if (componentPlatforms != other.componentPlatforms) return false
        if (componentVersion != other.componentVersion) return false
        if (lambdaArn != other.lambdaArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaFunctionRecipeSource = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaFunctionRecipeSource
        /**
         * The component versions on which this Lambda function component depends.
         */
        fun componentDependencies(componentDependencies: Map<String, ComponentDependencyRequirement>): FluentBuilder
        /**
         * The system and runtime parameters for the Lambda function as it runs on the Greengrass core
         * device.
         */
        fun componentLambdaParameters(componentLambdaParameters: LambdaExecutionParameters): FluentBuilder
        /**
         * The name of the component.
         * Defaults to the name of the Lambda function.
         */
        fun componentName(componentName: String): FluentBuilder
        /**
         * The platforms that the component version supports.
         */
        fun componentPlatforms(componentPlatforms: List<ComponentPlatform>): FluentBuilder
        /**
         * The version of the component.
         * Defaults to the version of the Lambda function as a semantic version. For example, if your
         * function version is 3, the component version becomes 3.0.0.
         */
        fun componentVersion(componentVersion: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Lambda function. The ARN must include the version of the function to
         * import. You can't use version aliases like $LATEST.
         */
        fun lambdaArn(lambdaArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The component versions on which this Lambda function component depends.
         */
        var componentDependencies: Map<String, ComponentDependencyRequirement>?
        /**
         * The system and runtime parameters for the Lambda function as it runs on the Greengrass core
         * device.
         */
        var componentLambdaParameters: LambdaExecutionParameters?
        /**
         * The name of the component.
         * Defaults to the name of the Lambda function.
         */
        var componentName: String?
        /**
         * The platforms that the component version supports.
         */
        var componentPlatforms: List<ComponentPlatform>?
        /**
         * The version of the component.
         * Defaults to the version of the Lambda function as a semantic version. For example, if your
         * function version is 3, the component version becomes 3.0.0.
         */
        var componentVersion: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Lambda function. The ARN must include the version of the function to
         * import. You can't use version aliases like $LATEST.
         */
        var lambdaArn: String?

        fun build(): LambdaFunctionRecipeSource
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters] inside the given [block]
         */
        fun componentLambdaParameters(block: LambdaExecutionParameters.DslBuilder.() -> kotlin.Unit) {
            this.componentLambdaParameters = LambdaExecutionParameters.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var componentDependencies: Map<String, ComponentDependencyRequirement>? = null
        override var componentLambdaParameters: LambdaExecutionParameters? = null
        override var componentName: String? = null
        override var componentPlatforms: List<ComponentPlatform>? = null
        override var componentVersion: String? = null
        override var lambdaArn: String? = null

        constructor(x: LambdaFunctionRecipeSource) : this() {
            this.componentDependencies = x.componentDependencies
            this.componentLambdaParameters = x.componentLambdaParameters
            this.componentName = x.componentName
            this.componentPlatforms = x.componentPlatforms
            this.componentVersion = x.componentVersion
            this.lambdaArn = x.lambdaArn
        }

        override fun build(): LambdaFunctionRecipeSource = LambdaFunctionRecipeSource(this)
        override fun componentDependencies(componentDependencies: Map<String, ComponentDependencyRequirement>): FluentBuilder = apply { this.componentDependencies = componentDependencies }
        override fun componentLambdaParameters(componentLambdaParameters: LambdaExecutionParameters): FluentBuilder = apply { this.componentLambdaParameters = componentLambdaParameters }
        override fun componentName(componentName: String): FluentBuilder = apply { this.componentName = componentName }
        override fun componentPlatforms(componentPlatforms: List<ComponentPlatform>): FluentBuilder = apply { this.componentPlatforms = componentPlatforms }
        override fun componentVersion(componentVersion: String): FluentBuilder = apply { this.componentVersion = componentVersion }
        override fun lambdaArn(lambdaArn: String): FluentBuilder = apply { this.lambdaArn = lambdaArn }
    }
}
