// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains parameters for a Lambda function that runs on IoT Greengrass.
 */
class LambdaExecutionParameters private constructor(builder: BuilderImpl) {
    /**
     * The map of environment variables that are available to the Lambda function when it runs.
     */
    val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * The list of event sources to which to subscribe to receive work messages. The Lambda
     * function runs when it receives a message from an event source. You can subscribe this function
     * to local publish/subscribe messages and Amazon Web Services IoT Core MQTT messages.
     */
    val eventSources: List<LambdaEventSource>? = builder.eventSources
    /**
     * The list of arguments to pass to the Lambda function when it runs.
     */
    val execArgs: List<String>? = builder.execArgs
    /**
     * The encoding type that the Lambda function supports.
     * Default: json
     */
    val inputPayloadEncodingType: LambdaInputPayloadEncodingType? = builder.inputPayloadEncodingType
    /**
     * The parameters for the Linux process that contains the Lambda function.
     */
    val linuxProcessParams: LambdaLinuxProcessParams? = builder.linuxProcessParams
    /**
     * The maximum amount of time in seconds that a non-pinned Lambda function can idle before the
     * IoT Greengrass Core software stops its process.
     */
    val maxIdleTimeInSeconds: Int = builder.maxIdleTimeInSeconds
    /**
     * The maximum number of instances that a non-pinned Lambda function can run at the same
     * time.
     */
    val maxInstancesCount: Int = builder.maxInstancesCount
    /**
     * The maximum size of the message queue for the Lambda function component. The IoT Greengrass core
     * stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to
     * consume each message.
     */
    val maxQueueSize: Int = builder.maxQueueSize
    /**
     * Whether or not the Lambda function is pinned, or long-lived.
     * A pinned Lambda function starts
     * when IoT Greengrass starts and keeps running in its own container.
     * A non-pinned Lambda function starts only when it receives a work item and exists after
     * it idles for maxIdleTimeInSeconds. If the function has multiple work items,
     * the IoT Greengrass Core software creates multiple instances of the function.
     * Default: true
     */
    val pinned: Boolean = builder.pinned
    /**
     * The interval in seconds at which a pinned (also known as long-lived) Lambda function
     * component sends status updates to the Lambda manager component.
     */
    val statusTimeoutInSeconds: Int = builder.statusTimeoutInSeconds
    /**
     * The maximum amount of time in seconds that the Lambda function can process a work
     * item.
     */
    val timeoutInSeconds: Int = builder.timeoutInSeconds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaExecutionParameters = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaExecutionParameters(")
        append("environmentVariables=$environmentVariables,")
        append("eventSources=$eventSources,")
        append("execArgs=$execArgs,")
        append("inputPayloadEncodingType=$inputPayloadEncodingType,")
        append("linuxProcessParams=$linuxProcessParams,")
        append("maxIdleTimeInSeconds=$maxIdleTimeInSeconds,")
        append("maxInstancesCount=$maxInstancesCount,")
        append("maxQueueSize=$maxQueueSize,")
        append("pinned=$pinned,")
        append("statusTimeoutInSeconds=$statusTimeoutInSeconds,")
        append("timeoutInSeconds=$timeoutInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = environmentVariables?.hashCode() ?: 0
        result = 31 * result + (eventSources?.hashCode() ?: 0)
        result = 31 * result + (execArgs?.hashCode() ?: 0)
        result = 31 * result + (inputPayloadEncodingType?.hashCode() ?: 0)
        result = 31 * result + (linuxProcessParams?.hashCode() ?: 0)
        result = 31 * result + (maxIdleTimeInSeconds)
        result = 31 * result + (maxInstancesCount)
        result = 31 * result + (maxQueueSize)
        result = 31 * result + (pinned.hashCode())
        result = 31 * result + (statusTimeoutInSeconds)
        result = 31 * result + (timeoutInSeconds)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaExecutionParameters

        if (environmentVariables != other.environmentVariables) return false
        if (eventSources != other.eventSources) return false
        if (execArgs != other.execArgs) return false
        if (inputPayloadEncodingType != other.inputPayloadEncodingType) return false
        if (linuxProcessParams != other.linuxProcessParams) return false
        if (maxIdleTimeInSeconds != other.maxIdleTimeInSeconds) return false
        if (maxInstancesCount != other.maxInstancesCount) return false
        if (maxQueueSize != other.maxQueueSize) return false
        if (pinned != other.pinned) return false
        if (statusTimeoutInSeconds != other.statusTimeoutInSeconds) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaExecutionParameters = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaExecutionParameters
        /**
         * The map of environment variables that are available to the Lambda function when it runs.
         */
        fun environmentVariables(environmentVariables: Map<String, String>): FluentBuilder
        /**
         * The list of event sources to which to subscribe to receive work messages. The Lambda
         * function runs when it receives a message from an event source. You can subscribe this function
         * to local publish/subscribe messages and Amazon Web Services IoT Core MQTT messages.
         */
        fun eventSources(eventSources: List<LambdaEventSource>): FluentBuilder
        /**
         * The list of arguments to pass to the Lambda function when it runs.
         */
        fun execArgs(execArgs: List<String>): FluentBuilder
        /**
         * The encoding type that the Lambda function supports.
         * Default: json
         */
        fun inputPayloadEncodingType(inputPayloadEncodingType: LambdaInputPayloadEncodingType): FluentBuilder
        /**
         * The parameters for the Linux process that contains the Lambda function.
         */
        fun linuxProcessParams(linuxProcessParams: LambdaLinuxProcessParams): FluentBuilder
        /**
         * The maximum amount of time in seconds that a non-pinned Lambda function can idle before the
         * IoT Greengrass Core software stops its process.
         */
        fun maxIdleTimeInSeconds(maxIdleTimeInSeconds: Int): FluentBuilder
        /**
         * The maximum number of instances that a non-pinned Lambda function can run at the same
         * time.
         */
        fun maxInstancesCount(maxInstancesCount: Int): FluentBuilder
        /**
         * The maximum size of the message queue for the Lambda function component. The IoT Greengrass core
         * stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to
         * consume each message.
         */
        fun maxQueueSize(maxQueueSize: Int): FluentBuilder
        /**
         * Whether or not the Lambda function is pinned, or long-lived.
         * A pinned Lambda function starts
         * when IoT Greengrass starts and keeps running in its own container.
         * A non-pinned Lambda function starts only when it receives a work item and exists after
         * it idles for maxIdleTimeInSeconds. If the function has multiple work items,
         * the IoT Greengrass Core software creates multiple instances of the function.
         * Default: true
         */
        fun pinned(pinned: Boolean): FluentBuilder
        /**
         * The interval in seconds at which a pinned (also known as long-lived) Lambda function
         * component sends status updates to the Lambda manager component.
         */
        fun statusTimeoutInSeconds(statusTimeoutInSeconds: Int): FluentBuilder
        /**
         * The maximum amount of time in seconds that the Lambda function can process a work
         * item.
         */
        fun timeoutInSeconds(timeoutInSeconds: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The map of environment variables that are available to the Lambda function when it runs.
         */
        var environmentVariables: Map<String, String>?
        /**
         * The list of event sources to which to subscribe to receive work messages. The Lambda
         * function runs when it receives a message from an event source. You can subscribe this function
         * to local publish/subscribe messages and Amazon Web Services IoT Core MQTT messages.
         */
        var eventSources: List<LambdaEventSource>?
        /**
         * The list of arguments to pass to the Lambda function when it runs.
         */
        var execArgs: List<String>?
        /**
         * The encoding type that the Lambda function supports.
         * Default: json
         */
        var inputPayloadEncodingType: LambdaInputPayloadEncodingType?
        /**
         * The parameters for the Linux process that contains the Lambda function.
         */
        var linuxProcessParams: LambdaLinuxProcessParams?
        /**
         * The maximum amount of time in seconds that a non-pinned Lambda function can idle before the
         * IoT Greengrass Core software stops its process.
         */
        var maxIdleTimeInSeconds: Int
        /**
         * The maximum number of instances that a non-pinned Lambda function can run at the same
         * time.
         */
        var maxInstancesCount: Int
        /**
         * The maximum size of the message queue for the Lambda function component. The IoT Greengrass core
         * stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to
         * consume each message.
         */
        var maxQueueSize: Int
        /**
         * Whether or not the Lambda function is pinned, or long-lived.
         * A pinned Lambda function starts
         * when IoT Greengrass starts and keeps running in its own container.
         * A non-pinned Lambda function starts only when it receives a work item and exists after
         * it idles for maxIdleTimeInSeconds. If the function has multiple work items,
         * the IoT Greengrass Core software creates multiple instances of the function.
         * Default: true
         */
        var pinned: Boolean
        /**
         * The interval in seconds at which a pinned (also known as long-lived) Lambda function
         * component sends status updates to the Lambda manager component.
         */
        var statusTimeoutInSeconds: Int
        /**
         * The maximum amount of time in seconds that the Lambda function can process a work
         * item.
         */
        var timeoutInSeconds: Int

        fun build(): LambdaExecutionParameters
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.LambdaLinuxProcessParams] inside the given [block]
         */
        fun linuxProcessParams(block: LambdaLinuxProcessParams.DslBuilder.() -> kotlin.Unit) {
            this.linuxProcessParams = LambdaLinuxProcessParams.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var environmentVariables: Map<String, String>? = null
        override var eventSources: List<LambdaEventSource>? = null
        override var execArgs: List<String>? = null
        override var inputPayloadEncodingType: LambdaInputPayloadEncodingType? = null
        override var linuxProcessParams: LambdaLinuxProcessParams? = null
        override var maxIdleTimeInSeconds: Int = 0
        override var maxInstancesCount: Int = 0
        override var maxQueueSize: Int = 0
        override var pinned: Boolean = false
        override var statusTimeoutInSeconds: Int = 0
        override var timeoutInSeconds: Int = 0

        constructor(x: LambdaExecutionParameters) : this() {
            this.environmentVariables = x.environmentVariables
            this.eventSources = x.eventSources
            this.execArgs = x.execArgs
            this.inputPayloadEncodingType = x.inputPayloadEncodingType
            this.linuxProcessParams = x.linuxProcessParams
            this.maxIdleTimeInSeconds = x.maxIdleTimeInSeconds
            this.maxInstancesCount = x.maxInstancesCount
            this.maxQueueSize = x.maxQueueSize
            this.pinned = x.pinned
            this.statusTimeoutInSeconds = x.statusTimeoutInSeconds
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        override fun build(): LambdaExecutionParameters = LambdaExecutionParameters(this)
        override fun environmentVariables(environmentVariables: Map<String, String>): FluentBuilder = apply { this.environmentVariables = environmentVariables }
        override fun eventSources(eventSources: List<LambdaEventSource>): FluentBuilder = apply { this.eventSources = eventSources }
        override fun execArgs(execArgs: List<String>): FluentBuilder = apply { this.execArgs = execArgs }
        override fun inputPayloadEncodingType(inputPayloadEncodingType: LambdaInputPayloadEncodingType): FluentBuilder = apply { this.inputPayloadEncodingType = inputPayloadEncodingType }
        override fun linuxProcessParams(linuxProcessParams: LambdaLinuxProcessParams): FluentBuilder = apply { this.linuxProcessParams = linuxProcessParams }
        override fun maxIdleTimeInSeconds(maxIdleTimeInSeconds: Int): FluentBuilder = apply { this.maxIdleTimeInSeconds = maxIdleTimeInSeconds }
        override fun maxInstancesCount(maxInstancesCount: Int): FluentBuilder = apply { this.maxInstancesCount = maxInstancesCount }
        override fun maxQueueSize(maxQueueSize: Int): FluentBuilder = apply { this.maxQueueSize = maxQueueSize }
        override fun pinned(pinned: Boolean): FluentBuilder = apply { this.pinned = pinned }
        override fun statusTimeoutInSeconds(statusTimeoutInSeconds: Int): FluentBuilder = apply { this.statusTimeoutInSeconds = statusTimeoutInSeconds }
        override fun timeoutInSeconds(timeoutInSeconds: Int): FluentBuilder = apply { this.timeoutInSeconds = timeoutInSeconds }
    }
}
