// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about an event source for an Lambda function. The event source
 * defines the topics on which this Lambda function subscribes to receive messages that run the
 * function.
 */
class LambdaEventSource private constructor(builder: BuilderImpl) {
    /**
     * The topic to which to subscribe to receive event messages.
     */
    val topic: String? = builder.topic
    /**
     * The type of event source. Choose from the following options:
     * PUB_SUB – Subscribe to local publish/subscribe messages. This event
     * source type doesn't support MQTT wildcards (+ and #) in the
     * event source topic.
     * IOT_CORE – Subscribe to Amazon Web Services IoT Core MQTT messages. This event source
     * type supports MQTT wildcards (+ and #) in the event source
     * topic.
     */
    val type: LambdaEventSourceType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaEventSource = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaEventSource(")
        append("topic=$topic,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = topic?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaEventSource

        if (topic != other.topic) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaEventSource = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaEventSource
        /**
         * The topic to which to subscribe to receive event messages.
         */
        fun topic(topic: String): FluentBuilder
        /**
         * The type of event source. Choose from the following options:
         * PUB_SUB – Subscribe to local publish/subscribe messages. This event
         * source type doesn't support MQTT wildcards (+ and #) in the
         * event source topic.
         * IOT_CORE – Subscribe to Amazon Web Services IoT Core MQTT messages. This event source
         * type supports MQTT wildcards (+ and #) in the event source
         * topic.
         */
        fun type(type: LambdaEventSourceType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The topic to which to subscribe to receive event messages.
         */
        var topic: String?
        /**
         * The type of event source. Choose from the following options:
         * PUB_SUB – Subscribe to local publish/subscribe messages. This event
         * source type doesn't support MQTT wildcards (+ and #) in the
         * event source topic.
         * IOT_CORE – Subscribe to Amazon Web Services IoT Core MQTT messages. This event source
         * type supports MQTT wildcards (+ and #) in the event source
         * topic.
         */
        var type: LambdaEventSourceType?

        fun build(): LambdaEventSource
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var topic: String? = null
        override var type: LambdaEventSourceType? = null

        constructor(x: LambdaEventSource) : this() {
            this.topic = x.topic
            this.type = x.type
        }

        override fun build(): LambdaEventSource = LambdaEventSource(this)
        override fun topic(topic: String): FluentBuilder = apply { this.topic = topic }
        override fun type(type: LambdaEventSourceType): FluentBuilder = apply { this.type = type }
    }
}
