// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a container in which Lambda functions run on Greengrass core
 * devices.
 */
class LambdaContainerParams private constructor(builder: BuilderImpl) {
    /**
     * The list of system devices that the container can access.
     */
    val devices: List<LambdaDeviceMount>? = builder.devices
    /**
     * The memory size of the container, expressed in kilobytes.
     * Default: 16384 (16 MB)
     */
    val memorySizeInKb: Int = builder.memorySizeInKb
    /**
     * Whether or not the container can read information from the device's /sys
     * folder.
     * Default: false
     */
    val mountRoSysfs: Boolean = builder.mountRoSysfs
    /**
     * The list of volumes that the container can access.
     */
    val volumes: List<LambdaVolumeMount>? = builder.volumes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaContainerParams = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaContainerParams(")
        append("devices=$devices,")
        append("memorySizeInKb=$memorySizeInKb,")
        append("mountRoSysfs=$mountRoSysfs,")
        append("volumes=$volumes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = devices?.hashCode() ?: 0
        result = 31 * result + (memorySizeInKb)
        result = 31 * result + (mountRoSysfs.hashCode())
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaContainerParams

        if (devices != other.devices) return false
        if (memorySizeInKb != other.memorySizeInKb) return false
        if (mountRoSysfs != other.mountRoSysfs) return false
        if (volumes != other.volumes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaContainerParams = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaContainerParams
        /**
         * The list of system devices that the container can access.
         */
        fun devices(devices: List<LambdaDeviceMount>): FluentBuilder
        /**
         * The memory size of the container, expressed in kilobytes.
         * Default: 16384 (16 MB)
         */
        fun memorySizeInKb(memorySizeInKb: Int): FluentBuilder
        /**
         * Whether or not the container can read information from the device's /sys
         * folder.
         * Default: false
         */
        fun mountRoSysfs(mountRoSysfs: Boolean): FluentBuilder
        /**
         * The list of volumes that the container can access.
         */
        fun volumes(volumes: List<LambdaVolumeMount>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The list of system devices that the container can access.
         */
        var devices: List<LambdaDeviceMount>?
        /**
         * The memory size of the container, expressed in kilobytes.
         * Default: 16384 (16 MB)
         */
        var memorySizeInKb: Int
        /**
         * Whether or not the container can read information from the device's /sys
         * folder.
         * Default: false
         */
        var mountRoSysfs: Boolean
        /**
         * The list of volumes that the container can access.
         */
        var volumes: List<LambdaVolumeMount>?

        fun build(): LambdaContainerParams
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var devices: List<LambdaDeviceMount>? = null
        override var memorySizeInKb: Int = 0
        override var mountRoSysfs: Boolean = false
        override var volumes: List<LambdaVolumeMount>? = null

        constructor(x: LambdaContainerParams) : this() {
            this.devices = x.devices
            this.memorySizeInKb = x.memorySizeInKb
            this.mountRoSysfs = x.mountRoSysfs
            this.volumes = x.volumes
        }

        override fun build(): LambdaContainerParams = LambdaContainerParams(this)
        override fun devices(devices: List<LambdaDeviceMount>): FluentBuilder = apply { this.devices = devices }
        override fun memorySizeInKb(memorySizeInKb: Int): FluentBuilder = apply { this.memorySizeInKb = memorySizeInKb }
        override fun mountRoSysfs(mountRoSysfs: Boolean): FluentBuilder = apply { this.mountRoSysfs = mountRoSysfs }
        override fun volumes(volumes: List<LambdaVolumeMount>): FluentBuilder = apply { this.volumes = volumes }
    }
}
