// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about an exponential rollout rate for a configuration deployment
 * job.
 */
class IoTJobExponentialRolloutRate private constructor(builder: BuilderImpl) {
    /**
     * The minimum number of devices that receive a pending job notification, per minute, when
     * the job starts. This parameter defines the initial rollout rate of the job.
     */
    val baseRatePerMinute: Int = builder.baseRatePerMinute
    /**
     * The exponential factor to increase the rollout rate for the job.
     * This parameter supports up to one digit after the decimal (for example, you can specify
     * 1.5, but not 1.55).
     */
    val incrementFactor: Double = builder.incrementFactor
    /**
     * The criteria to increase the rollout rate for the job.
     */
    val rateIncreaseCriteria: IoTJobRateIncreaseCriteria? = builder.rateIncreaseCriteria

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): IoTJobExponentialRolloutRate = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("IoTJobExponentialRolloutRate(")
        append("baseRatePerMinute=$baseRatePerMinute,")
        append("incrementFactor=$incrementFactor,")
        append("rateIncreaseCriteria=$rateIncreaseCriteria)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseRatePerMinute
        result = 31 * result + (incrementFactor.hashCode())
        result = 31 * result + (rateIncreaseCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IoTJobExponentialRolloutRate

        if (baseRatePerMinute != other.baseRatePerMinute) return false
        if (incrementFactor != other.incrementFactor) return false
        if (rateIncreaseCriteria != other.rateIncreaseCriteria) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): IoTJobExponentialRolloutRate = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): IoTJobExponentialRolloutRate
        /**
         * The minimum number of devices that receive a pending job notification, per minute, when
         * the job starts. This parameter defines the initial rollout rate of the job.
         */
        fun baseRatePerMinute(baseRatePerMinute: Int): FluentBuilder
        /**
         * The exponential factor to increase the rollout rate for the job.
         * This parameter supports up to one digit after the decimal (for example, you can specify
         * 1.5, but not 1.55).
         */
        fun incrementFactor(incrementFactor: Double): FluentBuilder
        /**
         * The criteria to increase the rollout rate for the job.
         */
        fun rateIncreaseCriteria(rateIncreaseCriteria: IoTJobRateIncreaseCriteria): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The minimum number of devices that receive a pending job notification, per minute, when
         * the job starts. This parameter defines the initial rollout rate of the job.
         */
        var baseRatePerMinute: Int
        /**
         * The exponential factor to increase the rollout rate for the job.
         * This parameter supports up to one digit after the decimal (for example, you can specify
         * 1.5, but not 1.55).
         */
        var incrementFactor: Double
        /**
         * The criteria to increase the rollout rate for the job.
         */
        var rateIncreaseCriteria: IoTJobRateIncreaseCriteria?

        fun build(): IoTJobExponentialRolloutRate
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.IoTJobRateIncreaseCriteria] inside the given [block]
         */
        fun rateIncreaseCriteria(block: IoTJobRateIncreaseCriteria.DslBuilder.() -> kotlin.Unit) {
            this.rateIncreaseCriteria = IoTJobRateIncreaseCriteria.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var baseRatePerMinute: Int = 0
        override var incrementFactor: Double = 0.0
        override var rateIncreaseCriteria: IoTJobRateIncreaseCriteria? = null

        constructor(x: IoTJobExponentialRolloutRate) : this() {
            this.baseRatePerMinute = x.baseRatePerMinute
            this.incrementFactor = x.incrementFactor
            this.rateIncreaseCriteria = x.rateIncreaseCriteria
        }

        override fun build(): IoTJobExponentialRolloutRate = IoTJobExponentialRolloutRate(this)
        override fun baseRatePerMinute(baseRatePerMinute: Int): FluentBuilder = apply { this.baseRatePerMinute = baseRatePerMinute }
        override fun incrementFactor(incrementFactor: Double): FluentBuilder = apply { this.incrementFactor = incrementFactor }
        override fun rateIncreaseCriteria(rateIncreaseCriteria: IoTJobRateIncreaseCriteria): FluentBuilder = apply { this.rateIncreaseCriteria = rateIncreaseCriteria }
    }
}
