// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains criteria that define when and how to cancel a job.
 * The deployment stops if the following conditions are true:
 * <ol>
 * The number of things that receive the deployment exceeds the
 * minNumberOfExecutedThings.
 * The percentage of failures with type failureType exceeds the
 * thresholdPercentage.
 * </ol>
 */
class IoTJobAbortCriteria private constructor(builder: BuilderImpl) {
    /**
     * The action to perform when the criteria are met.
     */
    val action: IoTJobAbortAction? = builder.action
    /**
     * The type of job deployment failure that can cancel a job.
     */
    val failureType: IoTJobExecutionFailureType? = builder.failureType
    /**
     * The minimum number of things that receive the configuration before the job can
     * cancel.
     */
    val minNumberOfExecutedThings: Int = builder.minNumberOfExecutedThings
    /**
     * The minimum percentage of failureType failures that occur before the job can
     * cancel.
     * This parameter supports up to two digits after the decimal (for example, you can specify
     * 10.9 or 10.99, but not 10.999).
     */
    val thresholdPercentage: Double = builder.thresholdPercentage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): IoTJobAbortCriteria = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("IoTJobAbortCriteria(")
        append("action=$action,")
        append("failureType=$failureType,")
        append("minNumberOfExecutedThings=$minNumberOfExecutedThings,")
        append("thresholdPercentage=$thresholdPercentage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (failureType?.hashCode() ?: 0)
        result = 31 * result + (minNumberOfExecutedThings)
        result = 31 * result + (thresholdPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IoTJobAbortCriteria

        if (action != other.action) return false
        if (failureType != other.failureType) return false
        if (minNumberOfExecutedThings != other.minNumberOfExecutedThings) return false
        if (thresholdPercentage != other.thresholdPercentage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): IoTJobAbortCriteria = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): IoTJobAbortCriteria
        /**
         * The action to perform when the criteria are met.
         */
        fun action(action: IoTJobAbortAction): FluentBuilder
        /**
         * The type of job deployment failure that can cancel a job.
         */
        fun failureType(failureType: IoTJobExecutionFailureType): FluentBuilder
        /**
         * The minimum number of things that receive the configuration before the job can
         * cancel.
         */
        fun minNumberOfExecutedThings(minNumberOfExecutedThings: Int): FluentBuilder
        /**
         * The minimum percentage of failureType failures that occur before the job can
         * cancel.
         * This parameter supports up to two digits after the decimal (for example, you can specify
         * 10.9 or 10.99, but not 10.999).
         */
        fun thresholdPercentage(thresholdPercentage: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action to perform when the criteria are met.
         */
        var action: IoTJobAbortAction?
        /**
         * The type of job deployment failure that can cancel a job.
         */
        var failureType: IoTJobExecutionFailureType?
        /**
         * The minimum number of things that receive the configuration before the job can
         * cancel.
         */
        var minNumberOfExecutedThings: Int
        /**
         * The minimum percentage of failureType failures that occur before the job can
         * cancel.
         * This parameter supports up to two digits after the decimal (for example, you can specify
         * 10.9 or 10.99, but not 10.999).
         */
        var thresholdPercentage: Double

        fun build(): IoTJobAbortCriteria
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: IoTJobAbortAction? = null
        override var failureType: IoTJobExecutionFailureType? = null
        override var minNumberOfExecutedThings: Int = 0
        override var thresholdPercentage: Double = 0.0

        constructor(x: IoTJobAbortCriteria) : this() {
            this.action = x.action
            this.failureType = x.failureType
            this.minNumberOfExecutedThings = x.minNumberOfExecutedThings
            this.thresholdPercentage = x.thresholdPercentage
        }

        override fun build(): IoTJobAbortCriteria = IoTJobAbortCriteria(this)
        override fun action(action: IoTJobAbortAction): FluentBuilder = apply { this.action = action }
        override fun failureType(failureType: IoTJobExecutionFailureType): FluentBuilder = apply { this.failureType = failureType }
        override fun minNumberOfExecutedThings(minNumberOfExecutedThings: Int): FluentBuilder = apply { this.minNumberOfExecutedThings = minNumberOfExecutedThings }
        override fun thresholdPercentage(thresholdPercentage: Double): FluentBuilder = apply { this.thresholdPercentage = thresholdPercentage }
    }
}
