// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a component on a Greengrass core device.
 */
class InstalledComponent private constructor(builder: BuilderImpl) {
    /**
     * The name of the component.
     */
    val componentName: String? = builder.componentName
    /**
     * The version of the component.
     */
    val componentVersion: String? = builder.componentVersion
    /**
     * Whether or not the component is a root component.
     */
    val isRoot: Boolean = builder.isRoot
    /**
     * The lifecycle state of the component.
     */
    val lifecycleState: InstalledComponentLifecycleState? = builder.lifecycleState
    /**
     * The details about the lifecycle state of the component.
     */
    val lifecycleStateDetails: String? = builder.lifecycleStateDetails

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstalledComponent = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstalledComponent(")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("isRoot=$isRoot,")
        append("lifecycleState=$lifecycleState,")
        append("lifecycleStateDetails=$lifecycleStateDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentName?.hashCode() ?: 0
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (isRoot.hashCode())
        result = 31 * result + (lifecycleState?.hashCode() ?: 0)
        result = 31 * result + (lifecycleStateDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstalledComponent

        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (isRoot != other.isRoot) return false
        if (lifecycleState != other.lifecycleState) return false
        if (lifecycleStateDetails != other.lifecycleStateDetails) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstalledComponent = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstalledComponent
        /**
         * The name of the component.
         */
        fun componentName(componentName: String): FluentBuilder
        /**
         * The version of the component.
         */
        fun componentVersion(componentVersion: String): FluentBuilder
        /**
         * Whether or not the component is a root component.
         */
        fun isRoot(isRoot: Boolean): FluentBuilder
        /**
         * The lifecycle state of the component.
         */
        fun lifecycleState(lifecycleState: InstalledComponentLifecycleState): FluentBuilder
        /**
         * The details about the lifecycle state of the component.
         */
        fun lifecycleStateDetails(lifecycleStateDetails: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the component.
         */
        var componentName: String?
        /**
         * The version of the component.
         */
        var componentVersion: String?
        /**
         * Whether or not the component is a root component.
         */
        var isRoot: Boolean
        /**
         * The lifecycle state of the component.
         */
        var lifecycleState: InstalledComponentLifecycleState?
        /**
         * The details about the lifecycle state of the component.
         */
        var lifecycleStateDetails: String?

        fun build(): InstalledComponent
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var componentName: String? = null
        override var componentVersion: String? = null
        override var isRoot: Boolean = false
        override var lifecycleState: InstalledComponentLifecycleState? = null
        override var lifecycleStateDetails: String? = null

        constructor(x: InstalledComponent) : this() {
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.isRoot = x.isRoot
            this.lifecycleState = x.lifecycleState
            this.lifecycleStateDetails = x.lifecycleStateDetails
        }

        override fun build(): InstalledComponent = InstalledComponent(this)
        override fun componentName(componentName: String): FluentBuilder = apply { this.componentName = componentName }
        override fun componentVersion(componentVersion: String): FluentBuilder = apply { this.componentVersion = componentVersion }
        override fun isRoot(isRoot: Boolean): FluentBuilder = apply { this.isRoot = isRoot }
        override fun lifecycleState(lifecycleState: InstalledComponentLifecycleState): FluentBuilder = apply { this.lifecycleState = lifecycleState }
        override fun lifecycleStateDetails(lifecycleStateDetails: String): FluentBuilder = apply { this.lifecycleStateDetails = lifecycleStateDetails }
    }
}
