// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

class GetDeploymentResponse private constructor(builder: BuilderImpl) {
    /**
     * The components to deploy. This is a dictionary, where each key is the name of a component,
     * and each key's value is the version and configuration to deploy for that component.
     */
    val components: Map<String, ComponentDeploymentSpecification>? = builder.components
    /**
     * The time at which the deployment was created, expressed in ISO 8601 format.
     */
    val creationTimestamp: Instant? = builder.creationTimestamp
    /**
     * The ID of the deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * The name of the deployment.
     */
    val deploymentName: String? = builder.deploymentName
    /**
     * The deployment policies for the deployment. These policies define how the deployment
     * updates components and handles failure.
     */
    val deploymentPolicies: DeploymentPolicies? = builder.deploymentPolicies
    /**
     * The status of the deployment.
     */
    val deploymentStatus: DeploymentStatus? = builder.deploymentStatus
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IoT job that applies the deployment to target devices.
     */
    val iotJobArn: String? = builder.iotJobArn
    /**
     * The job configuration for the deployment configuration. The job configuration specifies
     * the rollout, timeout, and stop configurations for the deployment configuration.
     */
    val iotJobConfiguration: DeploymentIoTJobConfiguration? = builder.iotJobConfiguration
    /**
     * The ID of the IoT job that applies the deployment to target devices.
     */
    val iotJobId: String? = builder.iotJobId
    /**
     * Whether or not the deployment is the latest revision for its target.
     */
    val isLatestForTarget: Boolean = builder.isLatestForTarget
    /**
     * The revision number of the deployment.
     */
    val revisionId: String? = builder.revisionId
    /**
     * A list of key-value pairs that contain metadata for the resource. For more
     * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
     * resources in the IoT Greengrass V2 Developer Guide.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
     */
    val targetArn: String? = builder.targetArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetDeploymentResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetDeploymentResponse(")
        append("components=$components,")
        append("creationTimestamp=$creationTimestamp,")
        append("deploymentId=$deploymentId,")
        append("deploymentName=$deploymentName,")
        append("deploymentPolicies=$deploymentPolicies,")
        append("deploymentStatus=$deploymentStatus,")
        append("iotJobArn=$iotJobArn,")
        append("iotJobConfiguration=$iotJobConfiguration,")
        append("iotJobId=$iotJobId,")
        append("isLatestForTarget=$isLatestForTarget,")
        append("revisionId=$revisionId,")
        append("tags=$tags,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = components?.hashCode() ?: 0
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (deploymentName?.hashCode() ?: 0)
        result = 31 * result + (deploymentPolicies?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (iotJobArn?.hashCode() ?: 0)
        result = 31 * result + (iotJobConfiguration?.hashCode() ?: 0)
        result = 31 * result + (iotJobId?.hashCode() ?: 0)
        result = 31 * result + (isLatestForTarget.hashCode())
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetDeploymentResponse

        if (components != other.components) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (deploymentId != other.deploymentId) return false
        if (deploymentName != other.deploymentName) return false
        if (deploymentPolicies != other.deploymentPolicies) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (iotJobArn != other.iotJobArn) return false
        if (iotJobConfiguration != other.iotJobConfiguration) return false
        if (iotJobId != other.iotJobId) return false
        if (isLatestForTarget != other.isLatestForTarget) return false
        if (revisionId != other.revisionId) return false
        if (tags != other.tags) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetDeploymentResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetDeploymentResponse
        /**
         * The components to deploy. This is a dictionary, where each key is the name of a component,
         * and each key's value is the version and configuration to deploy for that component.
         */
        fun components(components: Map<String, ComponentDeploymentSpecification>): FluentBuilder
        /**
         * The time at which the deployment was created, expressed in ISO 8601 format.
         */
        fun creationTimestamp(creationTimestamp: Instant): FluentBuilder
        /**
         * The ID of the deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * The name of the deployment.
         */
        fun deploymentName(deploymentName: String): FluentBuilder
        /**
         * The deployment policies for the deployment. These policies define how the deployment
         * updates components and handles failure.
         */
        fun deploymentPolicies(deploymentPolicies: DeploymentPolicies): FluentBuilder
        /**
         * The status of the deployment.
         */
        fun deploymentStatus(deploymentStatus: DeploymentStatus): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IoT job that applies the deployment to target devices.
         */
        fun iotJobArn(iotJobArn: String): FluentBuilder
        /**
         * The job configuration for the deployment configuration. The job configuration specifies
         * the rollout, timeout, and stop configurations for the deployment configuration.
         */
        fun iotJobConfiguration(iotJobConfiguration: DeploymentIoTJobConfiguration): FluentBuilder
        /**
         * The ID of the IoT job that applies the deployment to target devices.
         */
        fun iotJobId(iotJobId: String): FluentBuilder
        /**
         * Whether or not the deployment is the latest revision for its target.
         */
        fun isLatestForTarget(isLatestForTarget: Boolean): FluentBuilder
        /**
         * The revision number of the deployment.
         */
        fun revisionId(revisionId: String): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        fun targetArn(targetArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The components to deploy. This is a dictionary, where each key is the name of a component,
         * and each key's value is the version and configuration to deploy for that component.
         */
        var components: Map<String, ComponentDeploymentSpecification>?
        /**
         * The time at which the deployment was created, expressed in ISO 8601 format.
         */
        var creationTimestamp: Instant?
        /**
         * The ID of the deployment.
         */
        var deploymentId: String?
        /**
         * The name of the deployment.
         */
        var deploymentName: String?
        /**
         * The deployment policies for the deployment. These policies define how the deployment
         * updates components and handles failure.
         */
        var deploymentPolicies: DeploymentPolicies?
        /**
         * The status of the deployment.
         */
        var deploymentStatus: DeploymentStatus?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IoT job that applies the deployment to target devices.
         */
        var iotJobArn: String?
        /**
         * The job configuration for the deployment configuration. The job configuration specifies
         * the rollout, timeout, and stop configurations for the deployment configuration.
         */
        var iotJobConfiguration: DeploymentIoTJobConfiguration?
        /**
         * The ID of the IoT job that applies the deployment to target devices.
         */
        var iotJobId: String?
        /**
         * Whether or not the deployment is the latest revision for its target.
         */
        var isLatestForTarget: Boolean
        /**
         * The revision number of the deployment.
         */
        var revisionId: String?
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        var tags: Map<String, String>?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        var targetArn: String?

        fun build(): GetDeploymentResponse
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies] inside the given [block]
         */
        fun deploymentPolicies(block: DeploymentPolicies.DslBuilder.() -> kotlin.Unit) {
            this.deploymentPolicies = DeploymentPolicies.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentIoTJobConfiguration] inside the given [block]
         */
        fun iotJobConfiguration(block: DeploymentIoTJobConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.iotJobConfiguration = DeploymentIoTJobConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var components: Map<String, ComponentDeploymentSpecification>? = null
        override var creationTimestamp: Instant? = null
        override var deploymentId: String? = null
        override var deploymentName: String? = null
        override var deploymentPolicies: DeploymentPolicies? = null
        override var deploymentStatus: DeploymentStatus? = null
        override var iotJobArn: String? = null
        override var iotJobConfiguration: DeploymentIoTJobConfiguration? = null
        override var iotJobId: String? = null
        override var isLatestForTarget: Boolean = false
        override var revisionId: String? = null
        override var tags: Map<String, String>? = null
        override var targetArn: String? = null

        constructor(x: GetDeploymentResponse) : this() {
            this.components = x.components
            this.creationTimestamp = x.creationTimestamp
            this.deploymentId = x.deploymentId
            this.deploymentName = x.deploymentName
            this.deploymentPolicies = x.deploymentPolicies
            this.deploymentStatus = x.deploymentStatus
            this.iotJobArn = x.iotJobArn
            this.iotJobConfiguration = x.iotJobConfiguration
            this.iotJobId = x.iotJobId
            this.isLatestForTarget = x.isLatestForTarget
            this.revisionId = x.revisionId
            this.tags = x.tags
            this.targetArn = x.targetArn
        }

        override fun build(): GetDeploymentResponse = GetDeploymentResponse(this)
        override fun components(components: Map<String, ComponentDeploymentSpecification>): FluentBuilder = apply { this.components = components }
        override fun creationTimestamp(creationTimestamp: Instant): FluentBuilder = apply { this.creationTimestamp = creationTimestamp }
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun deploymentName(deploymentName: String): FluentBuilder = apply { this.deploymentName = deploymentName }
        override fun deploymentPolicies(deploymentPolicies: DeploymentPolicies): FluentBuilder = apply { this.deploymentPolicies = deploymentPolicies }
        override fun deploymentStatus(deploymentStatus: DeploymentStatus): FluentBuilder = apply { this.deploymentStatus = deploymentStatus }
        override fun iotJobArn(iotJobArn: String): FluentBuilder = apply { this.iotJobArn = iotJobArn }
        override fun iotJobConfiguration(iotJobConfiguration: DeploymentIoTJobConfiguration): FluentBuilder = apply { this.iotJobConfiguration = iotJobConfiguration }
        override fun iotJobId(iotJobId: String): FluentBuilder = apply { this.iotJobId = iotJobId }
        override fun isLatestForTarget(isLatestForTarget: Boolean): FluentBuilder = apply { this.isLatestForTarget = isLatestForTarget }
        override fun revisionId(revisionId: String): FluentBuilder = apply { this.revisionId = revisionId }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
    }
}
