// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

class GetCoreDeviceResponse private constructor(builder: BuilderImpl) {
    /**
     * The computer architecture of the core device.
     */
    val architecture: String? = builder.architecture
    /**
     * The name of the core device. This is also the name of the IoT thing.
     */
    val coreDeviceThingName: String? = builder.coreDeviceThingName
    /**
     * The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to
     * the version of the Greengrass nucleus component that runs on the core device. For more information,
     * see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
     * component in the IoT Greengrass V2 Developer Guide.
     */
    val coreVersion: String? = builder.coreVersion
    /**
     * The time at which the core device's status last updated, expressed in ISO 8601
     * format.
     */
    val lastStatusUpdateTimestamp: Instant? = builder.lastStatusUpdateTimestamp
    /**
     * The operating system platform that the core device runs.
     */
    val platform: String? = builder.platform
    /**
     * The status of the core device. The core device status can be:
     * HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.
     * UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state
     * on the core device.
     */
    val status: CoreDeviceStatus? = builder.status
    /**
     * A list of key-value pairs that contain metadata for the resource. For more
     * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
     * resources in the IoT Greengrass V2 Developer Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetCoreDeviceResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetCoreDeviceResponse(")
        append("architecture=$architecture,")
        append("coreDeviceThingName=$coreDeviceThingName,")
        append("coreVersion=$coreVersion,")
        append("lastStatusUpdateTimestamp=$lastStatusUpdateTimestamp,")
        append("platform=$platform,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (coreDeviceThingName?.hashCode() ?: 0)
        result = 31 * result + (coreVersion?.hashCode() ?: 0)
        result = 31 * result + (lastStatusUpdateTimestamp?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetCoreDeviceResponse

        if (architecture != other.architecture) return false
        if (coreDeviceThingName != other.coreDeviceThingName) return false
        if (coreVersion != other.coreVersion) return false
        if (lastStatusUpdateTimestamp != other.lastStatusUpdateTimestamp) return false
        if (platform != other.platform) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetCoreDeviceResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetCoreDeviceResponse
        /**
         * The computer architecture of the core device.
         */
        fun architecture(architecture: String): FluentBuilder
        /**
         * The name of the core device. This is also the name of the IoT thing.
         */
        fun coreDeviceThingName(coreDeviceThingName: String): FluentBuilder
        /**
         * The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to
         * the version of the Greengrass nucleus component that runs on the core device. For more information,
         * see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
         * component in the IoT Greengrass V2 Developer Guide.
         */
        fun coreVersion(coreVersion: String): FluentBuilder
        /**
         * The time at which the core device's status last updated, expressed in ISO 8601
         * format.
         */
        fun lastStatusUpdateTimestamp(lastStatusUpdateTimestamp: Instant): FluentBuilder
        /**
         * The operating system platform that the core device runs.
         */
        fun platform(platform: String): FluentBuilder
        /**
         * The status of the core device. The core device status can be:
         * HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.
         * UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state
         * on the core device.
         */
        fun status(status: CoreDeviceStatus): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The computer architecture of the core device.
         */
        var architecture: String?
        /**
         * The name of the core device. This is also the name of the IoT thing.
         */
        var coreDeviceThingName: String?
        /**
         * The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to
         * the version of the Greengrass nucleus component that runs on the core device. For more information,
         * see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
         * component in the IoT Greengrass V2 Developer Guide.
         */
        var coreVersion: String?
        /**
         * The time at which the core device's status last updated, expressed in ISO 8601
         * format.
         */
        var lastStatusUpdateTimestamp: Instant?
        /**
         * The operating system platform that the core device runs.
         */
        var platform: String?
        /**
         * The status of the core device. The core device status can be:
         * HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.
         * UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state
         * on the core device.
         */
        var status: CoreDeviceStatus?
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        var tags: Map<String, String>?

        fun build(): GetCoreDeviceResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var architecture: String? = null
        override var coreDeviceThingName: String? = null
        override var coreVersion: String? = null
        override var lastStatusUpdateTimestamp: Instant? = null
        override var platform: String? = null
        override var status: CoreDeviceStatus? = null
        override var tags: Map<String, String>? = null

        constructor(x: GetCoreDeviceResponse) : this() {
            this.architecture = x.architecture
            this.coreDeviceThingName = x.coreDeviceThingName
            this.coreVersion = x.coreVersion
            this.lastStatusUpdateTimestamp = x.lastStatusUpdateTimestamp
            this.platform = x.platform
            this.status = x.status
            this.tags = x.tags
        }

        override fun build(): GetCoreDeviceResponse = GetCoreDeviceResponse(this)
        override fun architecture(architecture: String): FluentBuilder = apply { this.architecture = architecture }
        override fun coreDeviceThingName(coreDeviceThingName: String): FluentBuilder = apply { this.coreDeviceThingName = coreDeviceThingName }
        override fun coreVersion(coreVersion: String): FluentBuilder = apply { this.coreVersion = coreVersion }
        override fun lastStatusUpdateTimestamp(lastStatusUpdateTimestamp: Instant): FluentBuilder = apply { this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp }
        override fun platform(platform: String): FluentBuilder = apply { this.platform = platform }
        override fun status(status: CoreDeviceStatus): FluentBuilder = apply { this.status = status }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
