// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



class GetComponentResponse private constructor(builder: BuilderImpl) {
    /**
     * The recipe of the component version.
     */
    val recipe: ByteArray? = builder.recipe
    /**
     * The format of the recipe.
     */
    val recipeOutputFormat: RecipeOutputFormat? = builder.recipeOutputFormat
    /**
     * A list of key-value pairs that contain metadata for the resource. For more
     * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
     * resources in the IoT Greengrass V2 Developer Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetComponentResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetComponentResponse(")
        append("recipe=$recipe,")
        append("recipeOutputFormat=$recipeOutputFormat,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = recipe?.contentHashCode() ?: 0
        result = 31 * result + (recipeOutputFormat?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetComponentResponse

        if (recipe != null) {
            if (other.recipe == null) return false
            if (!recipe.contentEquals(other.recipe)) return false
        } else if (other.recipe != null) return false
        if (recipeOutputFormat != other.recipeOutputFormat) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetComponentResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetComponentResponse
        /**
         * The recipe of the component version.
         */
        fun recipe(recipe: ByteArray): FluentBuilder
        /**
         * The format of the recipe.
         */
        fun recipeOutputFormat(recipeOutputFormat: RecipeOutputFormat): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The recipe of the component version.
         */
        var recipe: ByteArray?
        /**
         * The format of the recipe.
         */
        var recipeOutputFormat: RecipeOutputFormat?
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        var tags: Map<String, String>?

        fun build(): GetComponentResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var recipe: ByteArray? = null
        override var recipeOutputFormat: RecipeOutputFormat? = null
        override var tags: Map<String, String>? = null

        constructor(x: GetComponentResponse) : this() {
            this.recipe = x.recipe
            this.recipeOutputFormat = x.recipeOutputFormat
            this.tags = x.tags
        }

        override fun build(): GetComponentResponse = GetComponentResponse(this)
        override fun recipe(recipe: ByteArray): FluentBuilder = apply { this.recipe = recipe }
        override fun recipeOutputFormat(recipeOutputFormat: RecipeOutputFormat): FluentBuilder = apply { this.recipeOutputFormat = recipeOutputFormat }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
