// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a deployment job that IoT Greengrass sends to a Greengrass core device.
 */
class EffectiveDeployment private constructor(builder: BuilderImpl) {
    /**
     * The status of the deployment job on the Greengrass core device.
     */
    val coreDeviceExecutionStatus: EffectiveDeploymentExecutionStatus? = builder.coreDeviceExecutionStatus
    /**
     * The time at which the deployment was created, expressed in ISO 8601 format.
     */
    val creationTimestamp: Instant? = builder.creationTimestamp
    /**
     * The ID of the deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * The name of the deployment.
     */
    val deploymentName: String? = builder.deploymentName
    /**
     * The description of the deployment job.
     */
    val description: String? = builder.description
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IoT job that applies the deployment to target devices.
     */
    val iotJobArn: String? = builder.iotJobArn
    /**
     * The ID of the IoT job that applies the deployment to target devices.
     */
    val iotJobId: String? = builder.iotJobId
    /**
     * The time at which the deployment job was last modified, expressed in ISO 8601
     * format.
     */
    val modifiedTimestamp: Instant? = builder.modifiedTimestamp
    /**
     * The reason code for the update, if the job was updated.
     */
    val reason: String? = builder.reason
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
     */
    val targetArn: String? = builder.targetArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EffectiveDeployment = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EffectiveDeployment(")
        append("coreDeviceExecutionStatus=$coreDeviceExecutionStatus,")
        append("creationTimestamp=$creationTimestamp,")
        append("deploymentId=$deploymentId,")
        append("deploymentName=$deploymentName,")
        append("description=$description,")
        append("iotJobArn=$iotJobArn,")
        append("iotJobId=$iotJobId,")
        append("modifiedTimestamp=$modifiedTimestamp,")
        append("reason=$reason,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = coreDeviceExecutionStatus?.hashCode() ?: 0
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (deploymentName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (iotJobArn?.hashCode() ?: 0)
        result = 31 * result + (iotJobId?.hashCode() ?: 0)
        result = 31 * result + (modifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EffectiveDeployment

        if (coreDeviceExecutionStatus != other.coreDeviceExecutionStatus) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (deploymentId != other.deploymentId) return false
        if (deploymentName != other.deploymentName) return false
        if (description != other.description) return false
        if (iotJobArn != other.iotJobArn) return false
        if (iotJobId != other.iotJobId) return false
        if (modifiedTimestamp != other.modifiedTimestamp) return false
        if (reason != other.reason) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EffectiveDeployment = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EffectiveDeployment
        /**
         * The status of the deployment job on the Greengrass core device.
         */
        fun coreDeviceExecutionStatus(coreDeviceExecutionStatus: EffectiveDeploymentExecutionStatus): FluentBuilder
        /**
         * The time at which the deployment was created, expressed in ISO 8601 format.
         */
        fun creationTimestamp(creationTimestamp: Instant): FluentBuilder
        /**
         * The ID of the deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * The name of the deployment.
         */
        fun deploymentName(deploymentName: String): FluentBuilder
        /**
         * The description of the deployment job.
         */
        fun description(description: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IoT job that applies the deployment to target devices.
         */
        fun iotJobArn(iotJobArn: String): FluentBuilder
        /**
         * The ID of the IoT job that applies the deployment to target devices.
         */
        fun iotJobId(iotJobId: String): FluentBuilder
        /**
         * The time at which the deployment job was last modified, expressed in ISO 8601
         * format.
         */
        fun modifiedTimestamp(modifiedTimestamp: Instant): FluentBuilder
        /**
         * The reason code for the update, if the job was updated.
         */
        fun reason(reason: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        fun targetArn(targetArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The status of the deployment job on the Greengrass core device.
         */
        var coreDeviceExecutionStatus: EffectiveDeploymentExecutionStatus?
        /**
         * The time at which the deployment was created, expressed in ISO 8601 format.
         */
        var creationTimestamp: Instant?
        /**
         * The ID of the deployment.
         */
        var deploymentId: String?
        /**
         * The name of the deployment.
         */
        var deploymentName: String?
        /**
         * The description of the deployment job.
         */
        var description: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IoT job that applies the deployment to target devices.
         */
        var iotJobArn: String?
        /**
         * The ID of the IoT job that applies the deployment to target devices.
         */
        var iotJobId: String?
        /**
         * The time at which the deployment job was last modified, expressed in ISO 8601
         * format.
         */
        var modifiedTimestamp: Instant?
        /**
         * The reason code for the update, if the job was updated.
         */
        var reason: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        var targetArn: String?

        fun build(): EffectiveDeployment
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var coreDeviceExecutionStatus: EffectiveDeploymentExecutionStatus? = null
        override var creationTimestamp: Instant? = null
        override var deploymentId: String? = null
        override var deploymentName: String? = null
        override var description: String? = null
        override var iotJobArn: String? = null
        override var iotJobId: String? = null
        override var modifiedTimestamp: Instant? = null
        override var reason: String? = null
        override var targetArn: String? = null

        constructor(x: EffectiveDeployment) : this() {
            this.coreDeviceExecutionStatus = x.coreDeviceExecutionStatus
            this.creationTimestamp = x.creationTimestamp
            this.deploymentId = x.deploymentId
            this.deploymentName = x.deploymentName
            this.description = x.description
            this.iotJobArn = x.iotJobArn
            this.iotJobId = x.iotJobId
            this.modifiedTimestamp = x.modifiedTimestamp
            this.reason = x.reason
            this.targetArn = x.targetArn
        }

        override fun build(): EffectiveDeployment = EffectiveDeployment(this)
        override fun coreDeviceExecutionStatus(coreDeviceExecutionStatus: EffectiveDeploymentExecutionStatus): FluentBuilder = apply { this.coreDeviceExecutionStatus = coreDeviceExecutionStatus }
        override fun creationTimestamp(creationTimestamp: Instant): FluentBuilder = apply { this.creationTimestamp = creationTimestamp }
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun deploymentName(deploymentName: String): FluentBuilder = apply { this.deploymentName = deploymentName }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun iotJobArn(iotJobArn: String): FluentBuilder = apply { this.iotJobArn = iotJobArn }
        override fun iotJobId(iotJobId: String): FluentBuilder = apply { this.iotJobId = iotJobId }
        override fun modifiedTimestamp(modifiedTimestamp: Instant): FluentBuilder = apply { this.modifiedTimestamp = modifiedTimestamp }
        override fun reason(reason: String): FluentBuilder = apply { this.reason = reason }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
    }
}
