// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeComponentResponse private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
     */
    val arn: String? = builder.arn
    /**
     * The name of the component.
     */
    val componentName: String? = builder.componentName
    /**
     * The version of the component.
     */
    val componentVersion: String? = builder.componentVersion
    /**
     * The time at which the component was created, expressed in ISO 8601 format.
     */
    val creationTimestamp: Instant? = builder.creationTimestamp
    /**
     * The description of the component version.
     */
    val description: String? = builder.description
    /**
     * The platforms that the component version supports.
     */
    val platforms: List<ComponentPlatform>? = builder.platforms
    /**
     * The publisher of the component version.
     */
    val publisher: String? = builder.publisher
    /**
     * The status of the component version in IoT Greengrass V2. This status
     * is different from the status of the component on a core device.
     */
    val status: CloudComponentStatus? = builder.status
    /**
     * A list of key-value pairs that contain metadata for the resource. For more
     * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
     * resources in the IoT Greengrass V2 Developer Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeComponentResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeComponentResponse(")
        append("arn=$arn,")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("creationTimestamp=$creationTimestamp,")
        append("description=$description,")
        append("platforms=$platforms,")
        append("publisher=$publisher,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (platforms?.hashCode() ?: 0)
        result = 31 * result + (publisher?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeComponentResponse

        if (arn != other.arn) return false
        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (description != other.description) return false
        if (platforms != other.platforms) return false
        if (publisher != other.publisher) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeComponentResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeComponentResponse
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun componentName(componentName: String): FluentBuilder
        /**
         * The version of the component.
         */
        fun componentVersion(componentVersion: String): FluentBuilder
        /**
         * The time at which the component was created, expressed in ISO 8601 format.
         */
        fun creationTimestamp(creationTimestamp: Instant): FluentBuilder
        /**
         * The description of the component version.
         */
        fun description(description: String): FluentBuilder
        /**
         * The platforms that the component version supports.
         */
        fun platforms(platforms: List<ComponentPlatform>): FluentBuilder
        /**
         * The publisher of the component version.
         */
        fun publisher(publisher: String): FluentBuilder
        /**
         * The status of the component version in IoT Greengrass V2. This status
         * is different from the status of the component on a core device.
         */
        fun status(status: CloudComponentStatus): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        var arn: String?
        /**
         * The name of the component.
         */
        var componentName: String?
        /**
         * The version of the component.
         */
        var componentVersion: String?
        /**
         * The time at which the component was created, expressed in ISO 8601 format.
         */
        var creationTimestamp: Instant?
        /**
         * The description of the component version.
         */
        var description: String?
        /**
         * The platforms that the component version supports.
         */
        var platforms: List<ComponentPlatform>?
        /**
         * The publisher of the component version.
         */
        var publisher: String?
        /**
         * The status of the component version in IoT Greengrass V2. This status
         * is different from the status of the component on a core device.
         */
        var status: CloudComponentStatus?
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        var tags: Map<String, String>?

        fun build(): DescribeComponentResponse
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus] inside the given [block]
         */
        fun status(block: CloudComponentStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = CloudComponentStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var componentName: String? = null
        override var componentVersion: String? = null
        override var creationTimestamp: Instant? = null
        override var description: String? = null
        override var platforms: List<ComponentPlatform>? = null
        override var publisher: String? = null
        override var status: CloudComponentStatus? = null
        override var tags: Map<String, String>? = null

        constructor(x: DescribeComponentResponse) : this() {
            this.arn = x.arn
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.creationTimestamp = x.creationTimestamp
            this.description = x.description
            this.platforms = x.platforms
            this.publisher = x.publisher
            this.status = x.status
            this.tags = x.tags
        }

        override fun build(): DescribeComponentResponse = DescribeComponentResponse(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun componentName(componentName: String): FluentBuilder = apply { this.componentName = componentName }
        override fun componentVersion(componentVersion: String): FluentBuilder = apply { this.componentVersion = componentVersion }
        override fun creationTimestamp(creationTimestamp: Instant): FluentBuilder = apply { this.creationTimestamp = creationTimestamp }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun platforms(platforms: List<ComponentPlatform>): FluentBuilder = apply { this.platforms = platforms }
        override fun publisher(publisher: String): FluentBuilder = apply { this.publisher = publisher }
        override fun status(status: CloudComponentStatus): FluentBuilder = apply { this.status = status }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
