// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about policies that define how a deployment updates components and
 * handles failure.
 */
class DeploymentPolicies private constructor(builder: BuilderImpl) {
    /**
     * The component update policy for the configuration deployment. This policy defines when
     * it's safe to deploy the configuration to devices.
     */
    val componentUpdatePolicy: DeploymentComponentUpdatePolicy? = builder.componentUpdatePolicy
    /**
     * The configuration validation policy for the configuration deployment. This policy defines
     * how long each component has to validate its configure updates.
     */
    val configurationValidationPolicy: DeploymentConfigurationValidationPolicy? = builder.configurationValidationPolicy
    /**
     * The failure handling policy for the configuration deployment. This policy defines what to
     * do if the deployment fails.
     * Default: ROLLBACK
     */
    val failureHandlingPolicy: DeploymentFailureHandlingPolicy? = builder.failureHandlingPolicy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentPolicies = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentPolicies(")
        append("componentUpdatePolicy=$componentUpdatePolicy,")
        append("configurationValidationPolicy=$configurationValidationPolicy,")
        append("failureHandlingPolicy=$failureHandlingPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentUpdatePolicy?.hashCode() ?: 0
        result = 31 * result + (configurationValidationPolicy?.hashCode() ?: 0)
        result = 31 * result + (failureHandlingPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentPolicies

        if (componentUpdatePolicy != other.componentUpdatePolicy) return false
        if (configurationValidationPolicy != other.configurationValidationPolicy) return false
        if (failureHandlingPolicy != other.failureHandlingPolicy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentPolicies = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentPolicies
        /**
         * The component update policy for the configuration deployment. This policy defines when
         * it's safe to deploy the configuration to devices.
         */
        fun componentUpdatePolicy(componentUpdatePolicy: DeploymentComponentUpdatePolicy): FluentBuilder
        /**
         * The configuration validation policy for the configuration deployment. This policy defines
         * how long each component has to validate its configure updates.
         */
        fun configurationValidationPolicy(configurationValidationPolicy: DeploymentConfigurationValidationPolicy): FluentBuilder
        /**
         * The failure handling policy for the configuration deployment. This policy defines what to
         * do if the deployment fails.
         * Default: ROLLBACK
         */
        fun failureHandlingPolicy(failureHandlingPolicy: DeploymentFailureHandlingPolicy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The component update policy for the configuration deployment. This policy defines when
         * it's safe to deploy the configuration to devices.
         */
        var componentUpdatePolicy: DeploymentComponentUpdatePolicy?
        /**
         * The configuration validation policy for the configuration deployment. This policy defines
         * how long each component has to validate its configure updates.
         */
        var configurationValidationPolicy: DeploymentConfigurationValidationPolicy?
        /**
         * The failure handling policy for the configuration deployment. This policy defines what to
         * do if the deployment fails.
         * Default: ROLLBACK
         */
        var failureHandlingPolicy: DeploymentFailureHandlingPolicy?

        fun build(): DeploymentPolicies
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentComponentUpdatePolicy] inside the given [block]
         */
        fun componentUpdatePolicy(block: DeploymentComponentUpdatePolicy.DslBuilder.() -> kotlin.Unit) {
            this.componentUpdatePolicy = DeploymentComponentUpdatePolicy.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy] inside the given [block]
         */
        fun configurationValidationPolicy(block: DeploymentConfigurationValidationPolicy.DslBuilder.() -> kotlin.Unit) {
            this.configurationValidationPolicy = DeploymentConfigurationValidationPolicy.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var componentUpdatePolicy: DeploymentComponentUpdatePolicy? = null
        override var configurationValidationPolicy: DeploymentConfigurationValidationPolicy? = null
        override var failureHandlingPolicy: DeploymentFailureHandlingPolicy? = null

        constructor(x: DeploymentPolicies) : this() {
            this.componentUpdatePolicy = x.componentUpdatePolicy
            this.configurationValidationPolicy = x.configurationValidationPolicy
            this.failureHandlingPolicy = x.failureHandlingPolicy
        }

        override fun build(): DeploymentPolicies = DeploymentPolicies(this)
        override fun componentUpdatePolicy(componentUpdatePolicy: DeploymentComponentUpdatePolicy): FluentBuilder = apply { this.componentUpdatePolicy = componentUpdatePolicy }
        override fun configurationValidationPolicy(configurationValidationPolicy: DeploymentConfigurationValidationPolicy): FluentBuilder = apply { this.configurationValidationPolicy = configurationValidationPolicy }
        override fun failureHandlingPolicy(failureHandlingPolicy: DeploymentFailureHandlingPolicy): FluentBuilder = apply { this.failureHandlingPolicy = failureHandlingPolicy }
    }
}
