// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about an IoT job configuration.
 */
class DeploymentIoTJobConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The stop configuration for the job. This configuration defines when and how to stop a job
     * rollout.
     */
    val abortConfig: IoTJobAbortConfig? = builder.abortConfig
    /**
     * The rollout configuration for the job. This configuration defines the rate at which the
     * job rolls out to the fleet of target devices.
     */
    val jobExecutionsRolloutConfig: IoTJobExecutionsRolloutConfig? = builder.jobExecutionsRolloutConfig
    /**
     * The timeout configuration for the job. This configuration defines the amount of time each
     * device has to complete the job.
     */
    val timeoutConfig: IoTJobTimeoutConfig? = builder.timeoutConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentIoTJobConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentIoTJobConfiguration(")
        append("abortConfig=$abortConfig,")
        append("jobExecutionsRolloutConfig=$jobExecutionsRolloutConfig,")
        append("timeoutConfig=$timeoutConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortConfig?.hashCode() ?: 0
        result = 31 * result + (jobExecutionsRolloutConfig?.hashCode() ?: 0)
        result = 31 * result + (timeoutConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentIoTJobConfiguration

        if (abortConfig != other.abortConfig) return false
        if (jobExecutionsRolloutConfig != other.jobExecutionsRolloutConfig) return false
        if (timeoutConfig != other.timeoutConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentIoTJobConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentIoTJobConfiguration
        /**
         * The stop configuration for the job. This configuration defines when and how to stop a job
         * rollout.
         */
        fun abortConfig(abortConfig: IoTJobAbortConfig): FluentBuilder
        /**
         * The rollout configuration for the job. This configuration defines the rate at which the
         * job rolls out to the fleet of target devices.
         */
        fun jobExecutionsRolloutConfig(jobExecutionsRolloutConfig: IoTJobExecutionsRolloutConfig): FluentBuilder
        /**
         * The timeout configuration for the job. This configuration defines the amount of time each
         * device has to complete the job.
         */
        fun timeoutConfig(timeoutConfig: IoTJobTimeoutConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The stop configuration for the job. This configuration defines when and how to stop a job
         * rollout.
         */
        var abortConfig: IoTJobAbortConfig?
        /**
         * The rollout configuration for the job. This configuration defines the rate at which the
         * job rolls out to the fleet of target devices.
         */
        var jobExecutionsRolloutConfig: IoTJobExecutionsRolloutConfig?
        /**
         * The timeout configuration for the job. This configuration defines the amount of time each
         * device has to complete the job.
         */
        var timeoutConfig: IoTJobTimeoutConfig?

        fun build(): DeploymentIoTJobConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.IoTJobAbortConfig] inside the given [block]
         */
        fun abortConfig(block: IoTJobAbortConfig.DslBuilder.() -> kotlin.Unit) {
            this.abortConfig = IoTJobAbortConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.IoTJobExecutionsRolloutConfig] inside the given [block]
         */
        fun jobExecutionsRolloutConfig(block: IoTJobExecutionsRolloutConfig.DslBuilder.() -> kotlin.Unit) {
            this.jobExecutionsRolloutConfig = IoTJobExecutionsRolloutConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.IoTJobTimeoutConfig] inside the given [block]
         */
        fun timeoutConfig(block: IoTJobTimeoutConfig.DslBuilder.() -> kotlin.Unit) {
            this.timeoutConfig = IoTJobTimeoutConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var abortConfig: IoTJobAbortConfig? = null
        override var jobExecutionsRolloutConfig: IoTJobExecutionsRolloutConfig? = null
        override var timeoutConfig: IoTJobTimeoutConfig? = null

        constructor(x: DeploymentIoTJobConfiguration) : this() {
            this.abortConfig = x.abortConfig
            this.jobExecutionsRolloutConfig = x.jobExecutionsRolloutConfig
            this.timeoutConfig = x.timeoutConfig
        }

        override fun build(): DeploymentIoTJobConfiguration = DeploymentIoTJobConfiguration(this)
        override fun abortConfig(abortConfig: IoTJobAbortConfig): FluentBuilder = apply { this.abortConfig = abortConfig }
        override fun jobExecutionsRolloutConfig(jobExecutionsRolloutConfig: IoTJobExecutionsRolloutConfig): FluentBuilder = apply { this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig }
        override fun timeoutConfig(timeoutConfig: IoTJobTimeoutConfig): FluentBuilder = apply { this.timeoutConfig = timeoutConfig }
    }
}
