// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about how long a component on a core device can validate its
 * configuration updates before it times out. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetovalidateconfigurationupdates">SubscribeToValidateConfigurationUpdates IPC operation to receive notifications when
 * a deployment specifies a configuration update. Then, components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-sendconfigurationvalidityreport">SendConfigurationValidityReport IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments in the IoT Greengrass V2 Developer Guide.
 */
class DeploymentConfigurationValidationPolicy private constructor(builder: BuilderImpl) {
    /**
     * The amount of time in seconds that a component can validate its configuration updates. If
     * the validation time exceeds this timeout, then the deployment proceeds for the device.
     * Default: 30
     */
    val timeoutInSeconds: Int = builder.timeoutInSeconds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentConfigurationValidationPolicy = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentConfigurationValidationPolicy(")
        append("timeoutInSeconds=$timeoutInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = timeoutInSeconds
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentConfigurationValidationPolicy

        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentConfigurationValidationPolicy = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentConfigurationValidationPolicy
        /**
         * The amount of time in seconds that a component can validate its configuration updates. If
         * the validation time exceeds this timeout, then the deployment proceeds for the device.
         * Default: 30
         */
        fun timeoutInSeconds(timeoutInSeconds: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The amount of time in seconds that a component can validate its configuration updates. If
         * the validation time exceeds this timeout, then the deployment proceeds for the device.
         * Default: 30
         */
        var timeoutInSeconds: Int

        fun build(): DeploymentConfigurationValidationPolicy
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var timeoutInSeconds: Int = 0

        constructor(x: DeploymentConfigurationValidationPolicy) : this() {
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        override fun build(): DeploymentConfigurationValidationPolicy = DeploymentConfigurationValidationPolicy(this)
        override fun timeoutInSeconds(timeoutInSeconds: Int): FluentBuilder = apply { this.timeoutInSeconds = timeoutInSeconds }
    }
}
