// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a deployment's policy that defines when components are safe to
 * update.
 * Each component on a device can report whether or not it's ready to update. After a
 * component and its dependencies are ready, they can apply the update in the deployment. You can
 * configure whether or not the deployment notifies components of an update and waits for a
 * response. You specify the amount of time each component has to respond to the update
 * notification.
 */
class DeploymentComponentUpdatePolicy private constructor(builder: BuilderImpl) {
    /**
     * Whether or not to notify components and wait for components to become safe to update.
     * Choose from the following options:
     * NOTIFY_COMPONENTS – The deployment notifies each component before
     * it stops and updates that component. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates">SubscribeToComponentUpdates IPC operation to receive these notifications. Then,
     * components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate">DeferComponentUpdate IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments in the IoT Greengrass V2 Developer Guide.
     * SKIP_NOTIFY_COMPONENTS – The deployment doesn't notify components
     * or wait for them to be safe to update.
     * Default: NOTIFY_COMPONENTS
     */
    val action: DeploymentComponentUpdatePolicyAction? = builder.action
    /**
     * The amount of time in seconds that each component on a device has to report that it's safe
     * to update. If the component waits for longer than this timeout, then the deployment proceeds
     * on the device.
     * Default: 60
     */
    val timeoutInSeconds: Int = builder.timeoutInSeconds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentComponentUpdatePolicy = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentComponentUpdatePolicy(")
        append("action=$action,")
        append("timeoutInSeconds=$timeoutInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (timeoutInSeconds)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentComponentUpdatePolicy

        if (action != other.action) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentComponentUpdatePolicy = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentComponentUpdatePolicy
        /**
         * Whether or not to notify components and wait for components to become safe to update.
         * Choose from the following options:
         * NOTIFY_COMPONENTS – The deployment notifies each component before
         * it stops and updates that component. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates">SubscribeToComponentUpdates IPC operation to receive these notifications. Then,
         * components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate">DeferComponentUpdate IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments in the IoT Greengrass V2 Developer Guide.
         * SKIP_NOTIFY_COMPONENTS – The deployment doesn't notify components
         * or wait for them to be safe to update.
         * Default: NOTIFY_COMPONENTS
         */
        fun action(action: DeploymentComponentUpdatePolicyAction): FluentBuilder
        /**
         * The amount of time in seconds that each component on a device has to report that it's safe
         * to update. If the component waits for longer than this timeout, then the deployment proceeds
         * on the device.
         * Default: 60
         */
        fun timeoutInSeconds(timeoutInSeconds: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Whether or not to notify components and wait for components to become safe to update.
         * Choose from the following options:
         * NOTIFY_COMPONENTS – The deployment notifies each component before
         * it stops and updates that component. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates">SubscribeToComponentUpdates IPC operation to receive these notifications. Then,
         * components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate">DeferComponentUpdate IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments in the IoT Greengrass V2 Developer Guide.
         * SKIP_NOTIFY_COMPONENTS – The deployment doesn't notify components
         * or wait for them to be safe to update.
         * Default: NOTIFY_COMPONENTS
         */
        var action: DeploymentComponentUpdatePolicyAction?
        /**
         * The amount of time in seconds that each component on a device has to report that it's safe
         * to update. If the component waits for longer than this timeout, then the deployment proceeds
         * on the device.
         * Default: 60
         */
        var timeoutInSeconds: Int

        fun build(): DeploymentComponentUpdatePolicy
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: DeploymentComponentUpdatePolicyAction? = null
        override var timeoutInSeconds: Int = 0

        constructor(x: DeploymentComponentUpdatePolicy) : this() {
            this.action = x.action
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        override fun build(): DeploymentComponentUpdatePolicy = DeploymentComponentUpdatePolicy(this)
        override fun action(action: DeploymentComponentUpdatePolicyAction): FluentBuilder = apply { this.action = action }
        override fun timeoutInSeconds(timeoutInSeconds: Int): FluentBuilder = apply { this.timeoutInSeconds = timeoutInSeconds }
    }
}
