// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a deployment.
 */
class Deployment private constructor(builder: BuilderImpl) {
    /**
     * The time at which the deployment was created, expressed in ISO 8601 format.
     */
    val creationTimestamp: Instant? = builder.creationTimestamp
    /**
     * The ID of the deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * The name of the deployment.
     */
    val deploymentName: String? = builder.deploymentName
    /**
     * The status of the deployment.
     */
    val deploymentStatus: DeploymentStatus? = builder.deploymentStatus
    /**
     * Whether or not the deployment is the latest revision for its target.
     */
    val isLatestForTarget: Boolean = builder.isLatestForTarget
    /**
     * The revision number of the deployment.
     */
    val revisionId: String? = builder.revisionId
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
     */
    val targetArn: String? = builder.targetArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Deployment = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Deployment(")
        append("creationTimestamp=$creationTimestamp,")
        append("deploymentId=$deploymentId,")
        append("deploymentName=$deploymentName,")
        append("deploymentStatus=$deploymentStatus,")
        append("isLatestForTarget=$isLatestForTarget,")
        append("revisionId=$revisionId,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (deploymentName?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (isLatestForTarget.hashCode())
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Deployment

        if (creationTimestamp != other.creationTimestamp) return false
        if (deploymentId != other.deploymentId) return false
        if (deploymentName != other.deploymentName) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (isLatestForTarget != other.isLatestForTarget) return false
        if (revisionId != other.revisionId) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Deployment = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Deployment
        /**
         * The time at which the deployment was created, expressed in ISO 8601 format.
         */
        fun creationTimestamp(creationTimestamp: Instant): FluentBuilder
        /**
         * The ID of the deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * The name of the deployment.
         */
        fun deploymentName(deploymentName: String): FluentBuilder
        /**
         * The status of the deployment.
         */
        fun deploymentStatus(deploymentStatus: DeploymentStatus): FluentBuilder
        /**
         * Whether or not the deployment is the latest revision for its target.
         */
        fun isLatestForTarget(isLatestForTarget: Boolean): FluentBuilder
        /**
         * The revision number of the deployment.
         */
        fun revisionId(revisionId: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        fun targetArn(targetArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time at which the deployment was created, expressed in ISO 8601 format.
         */
        var creationTimestamp: Instant?
        /**
         * The ID of the deployment.
         */
        var deploymentId: String?
        /**
         * The name of the deployment.
         */
        var deploymentName: String?
        /**
         * The status of the deployment.
         */
        var deploymentStatus: DeploymentStatus?
        /**
         * Whether or not the deployment is the latest revision for its target.
         */
        var isLatestForTarget: Boolean
        /**
         * The revision number of the deployment.
         */
        var revisionId: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        var targetArn: String?

        fun build(): Deployment
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationTimestamp: Instant? = null
        override var deploymentId: String? = null
        override var deploymentName: String? = null
        override var deploymentStatus: DeploymentStatus? = null
        override var isLatestForTarget: Boolean = false
        override var revisionId: String? = null
        override var targetArn: String? = null

        constructor(x: Deployment) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.deploymentId = x.deploymentId
            this.deploymentName = x.deploymentName
            this.deploymentStatus = x.deploymentStatus
            this.isLatestForTarget = x.isLatestForTarget
            this.revisionId = x.revisionId
            this.targetArn = x.targetArn
        }

        override fun build(): Deployment = Deployment(this)
        override fun creationTimestamp(creationTimestamp: Instant): FluentBuilder = apply { this.creationTimestamp = creationTimestamp }
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun deploymentName(deploymentName: String): FluentBuilder = apply { this.deploymentName = deploymentName }
        override fun deploymentStatus(deploymentStatus: DeploymentStatus): FluentBuilder = apply { this.deploymentStatus = deploymentStatus }
        override fun isLatestForTarget(isLatestForTarget: Boolean): FluentBuilder = apply { this.isLatestForTarget = isLatestForTarget }
        override fun revisionId(revisionId: String): FluentBuilder = apply { this.revisionId = revisionId }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
    }
}
