// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



class CreateDeploymentRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
     * Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
     * When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
     * returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
     * idempotent requests for up to 8 hours.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The components to deploy. This is a dictionary, where each key is the name of a component,
     * and each key's value is the version and configuration to deploy for that component.
     */
    val components: Map<String, ComponentDeploymentSpecification>? = builder.components
    /**
     * The name of the deployment.
     */
    val deploymentName: String? = builder.deploymentName
    /**
     * The deployment policies for the deployment. These policies define how the deployment
     * updates components and handles failure.
     */
    val deploymentPolicies: DeploymentPolicies? = builder.deploymentPolicies
    /**
     * The job configuration for the deployment configuration. The job configuration specifies
     * the rollout, timeout, and stop configurations for the deployment configuration.
     */
    val iotJobConfiguration: DeploymentIoTJobConfiguration? = builder.iotJobConfiguration
    /**
     * A list of key-value pairs that contain metadata for the resource. For more
     * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
     * resources in the IoT Greengrass V2 Developer Guide.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
     */
    val targetArn: String? = builder.targetArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDeploymentRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentRequest(")
        append("clientToken=$clientToken,")
        append("components=$components,")
        append("deploymentName=$deploymentName,")
        append("deploymentPolicies=$deploymentPolicies,")
        append("iotJobConfiguration=$iotJobConfiguration,")
        append("tags=$tags,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (deploymentName?.hashCode() ?: 0)
        result = 31 * result + (deploymentPolicies?.hashCode() ?: 0)
        result = 31 * result + (iotJobConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDeploymentRequest

        if (clientToken != other.clientToken) return false
        if (components != other.components) return false
        if (deploymentName != other.deploymentName) return false
        if (deploymentPolicies != other.deploymentPolicies) return false
        if (iotJobConfiguration != other.iotJobConfiguration) return false
        if (tags != other.tags) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDeploymentRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDeploymentRequest
        /**
         * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
         * Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
         * When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
         * returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
         * idempotent requests for up to 8 hours.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The components to deploy. This is a dictionary, where each key is the name of a component,
         * and each key's value is the version and configuration to deploy for that component.
         */
        fun components(components: Map<String, ComponentDeploymentSpecification>): FluentBuilder
        /**
         * The name of the deployment.
         */
        fun deploymentName(deploymentName: String): FluentBuilder
        /**
         * The deployment policies for the deployment. These policies define how the deployment
         * updates components and handles failure.
         */
        fun deploymentPolicies(deploymentPolicies: DeploymentPolicies): FluentBuilder
        /**
         * The job configuration for the deployment configuration. The job configuration specifies
         * the rollout, timeout, and stop configurations for the deployment configuration.
         */
        fun iotJobConfiguration(iotJobConfiguration: DeploymentIoTJobConfiguration): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        fun targetArn(targetArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
         * Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
         * When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
         * returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
         * idempotent requests for up to 8 hours.
         */
        var clientToken: String?
        /**
         * The components to deploy. This is a dictionary, where each key is the name of a component,
         * and each key's value is the version and configuration to deploy for that component.
         */
        var components: Map<String, ComponentDeploymentSpecification>?
        /**
         * The name of the deployment.
         */
        var deploymentName: String?
        /**
         * The deployment policies for the deployment. These policies define how the deployment
         * updates components and handles failure.
         */
        var deploymentPolicies: DeploymentPolicies?
        /**
         * The job configuration for the deployment configuration. The job configuration specifies
         * the rollout, timeout, and stop configurations for the deployment configuration.
         */
        var iotJobConfiguration: DeploymentIoTJobConfiguration?
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        var tags: Map<String, String>?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the target IoT thing or thing group.
         */
        var targetArn: String?

        fun build(): CreateDeploymentRequest
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies] inside the given [block]
         */
        fun deploymentPolicies(block: DeploymentPolicies.DslBuilder.() -> kotlin.Unit) {
            this.deploymentPolicies = DeploymentPolicies.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentIoTJobConfiguration] inside the given [block]
         */
        fun iotJobConfiguration(block: DeploymentIoTJobConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.iotJobConfiguration = DeploymentIoTJobConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var components: Map<String, ComponentDeploymentSpecification>? = null
        override var deploymentName: String? = null
        override var deploymentPolicies: DeploymentPolicies? = null
        override var iotJobConfiguration: DeploymentIoTJobConfiguration? = null
        override var tags: Map<String, String>? = null
        override var targetArn: String? = null

        constructor(x: CreateDeploymentRequest) : this() {
            this.clientToken = x.clientToken
            this.components = x.components
            this.deploymentName = x.deploymentName
            this.deploymentPolicies = x.deploymentPolicies
            this.iotJobConfiguration = x.iotJobConfiguration
            this.tags = x.tags
            this.targetArn = x.targetArn
        }

        override fun build(): CreateDeploymentRequest = CreateDeploymentRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun components(components: Map<String, ComponentDeploymentSpecification>): FluentBuilder = apply { this.components = components }
        override fun deploymentName(deploymentName: String): FluentBuilder = apply { this.deploymentName = deploymentName }
        override fun deploymentPolicies(deploymentPolicies: DeploymentPolicies): FluentBuilder = apply { this.deploymentPolicies = deploymentPolicies }
        override fun iotJobConfiguration(iotJobConfiguration: DeploymentIoTJobConfiguration): FluentBuilder = apply { this.iotJobConfiguration = iotJobConfiguration }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
    }
}
