// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

class CreateComponentVersionResponse private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
     */
    val arn: String? = builder.arn
    /**
     * The name of the component.
     */
    val componentName: String? = builder.componentName
    /**
     * The version of the component.
     */
    val componentVersion: String? = builder.componentVersion
    /**
     * The time at which the component was created, expressed in ISO 8601 format.
     */
    val creationTimestamp: Instant? = builder.creationTimestamp
    /**
     * The status of the component version in IoT Greengrass V2. This status
     * is different from the status of the component on a core device.
     */
    val status: CloudComponentStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateComponentVersionResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateComponentVersionResponse(")
        append("arn=$arn,")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("creationTimestamp=$creationTimestamp,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateComponentVersionResponse

        if (arn != other.arn) return false
        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateComponentVersionResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateComponentVersionResponse
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun componentName(componentName: String): FluentBuilder
        /**
         * The version of the component.
         */
        fun componentVersion(componentVersion: String): FluentBuilder
        /**
         * The time at which the component was created, expressed in ISO 8601 format.
         */
        fun creationTimestamp(creationTimestamp: Instant): FluentBuilder
        /**
         * The status of the component version in IoT Greengrass V2. This status
         * is different from the status of the component on a core device.
         */
        fun status(status: CloudComponentStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        var arn: String?
        /**
         * The name of the component.
         */
        var componentName: String?
        /**
         * The version of the component.
         */
        var componentVersion: String?
        /**
         * The time at which the component was created, expressed in ISO 8601 format.
         */
        var creationTimestamp: Instant?
        /**
         * The status of the component version in IoT Greengrass V2. This status
         * is different from the status of the component on a core device.
         */
        var status: CloudComponentStatus?

        fun build(): CreateComponentVersionResponse
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus] inside the given [block]
         */
        fun status(block: CloudComponentStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = CloudComponentStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var componentName: String? = null
        override var componentVersion: String? = null
        override var creationTimestamp: Instant? = null
        override var status: CloudComponentStatus? = null

        constructor(x: CreateComponentVersionResponse) : this() {
            this.arn = x.arn
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.creationTimestamp = x.creationTimestamp
            this.status = x.status
        }

        override fun build(): CreateComponentVersionResponse = CreateComponentVersionResponse(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun componentName(componentName: String): FluentBuilder = apply { this.componentName = componentName }
        override fun componentVersion(componentVersion: String): FluentBuilder = apply { this.componentVersion = componentVersion }
        override fun creationTimestamp(creationTimestamp: Instant): FluentBuilder = apply { this.creationTimestamp = creationTimestamp }
        override fun status(status: CloudComponentStatus): FluentBuilder = apply { this.status = status }
    }
}
