// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



class CreateComponentVersionRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
     * Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
     * When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
     * returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
     * idempotent requests for up to 8 hours.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The recipe to use to create the component. The recipe defines the component's metadata,
     * parameters, dependencies, lifecycle, artifacts, and platform compatibility.
     * You must specify either inlineRecipe or lambdaFunction.
     */
    val inlineRecipe: ByteArray? = builder.inlineRecipe
    /**
     * The parameters to create a component from a Lambda function.
     * You must specify either inlineRecipe or lambdaFunction.
     */
    val lambdaFunction: LambdaFunctionRecipeSource? = builder.lambdaFunction
    /**
     * A list of key-value pairs that contain metadata for the resource. For more
     * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
     * resources in the IoT Greengrass V2 Developer Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateComponentVersionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateComponentVersionRequest(")
        append("clientToken=$clientToken,")
        append("inlineRecipe=$inlineRecipe,")
        append("lambdaFunction=$lambdaFunction,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (inlineRecipe?.contentHashCode() ?: 0)
        result = 31 * result + (lambdaFunction?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateComponentVersionRequest

        if (clientToken != other.clientToken) return false
        if (inlineRecipe != null) {
            if (other.inlineRecipe == null) return false
            if (!inlineRecipe.contentEquals(other.inlineRecipe)) return false
        } else if (other.inlineRecipe != null) return false
        if (lambdaFunction != other.lambdaFunction) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateComponentVersionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateComponentVersionRequest
        /**
         * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
         * Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
         * When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
         * returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
         * idempotent requests for up to 8 hours.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The recipe to use to create the component. The recipe defines the component's metadata,
         * parameters, dependencies, lifecycle, artifacts, and platform compatibility.
         * You must specify either inlineRecipe or lambdaFunction.
         */
        fun inlineRecipe(inlineRecipe: ByteArray): FluentBuilder
        /**
         * The parameters to create a component from a Lambda function.
         * You must specify either inlineRecipe or lambdaFunction.
         */
        fun lambdaFunction(lambdaFunction: LambdaFunctionRecipeSource): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
         * Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
         * When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
         * returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
         * idempotent requests for up to 8 hours.
         */
        var clientToken: String?
        /**
         * The recipe to use to create the component. The recipe defines the component's metadata,
         * parameters, dependencies, lifecycle, artifacts, and platform compatibility.
         * You must specify either inlineRecipe or lambdaFunction.
         */
        var inlineRecipe: ByteArray?
        /**
         * The parameters to create a component from a Lambda function.
         * You must specify either inlineRecipe or lambdaFunction.
         */
        var lambdaFunction: LambdaFunctionRecipeSource?
        /**
         * A list of key-value pairs that contain metadata for the resource. For more
         * information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         * resources in the IoT Greengrass V2 Developer Guide.
         */
        var tags: Map<String, String>?

        fun build(): CreateComponentVersionRequest
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource] inside the given [block]
         */
        fun lambdaFunction(block: LambdaFunctionRecipeSource.DslBuilder.() -> kotlin.Unit) {
            this.lambdaFunction = LambdaFunctionRecipeSource.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var inlineRecipe: ByteArray? = null
        override var lambdaFunction: LambdaFunctionRecipeSource? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateComponentVersionRequest) : this() {
            this.clientToken = x.clientToken
            this.inlineRecipe = x.inlineRecipe
            this.lambdaFunction = x.lambdaFunction
            this.tags = x.tags
        }

        override fun build(): CreateComponentVersionRequest = CreateComponentVersionRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun inlineRecipe(inlineRecipe: ByteArray): FluentBuilder = apply { this.inlineRecipe = inlineRecipe }
        override fun lambdaFunction(lambdaFunction: LambdaFunctionRecipeSource): FluentBuilder = apply { this.lambdaFunction = lambdaFunction }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
