// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a Greengrass core device, which is an IoT thing that runs the IoT Greengrass
 * Core software.
 */
class CoreDevice private constructor(builder: BuilderImpl) {
    /**
     * The name of the core device. This is also the name of the IoT thing.
     */
    val coreDeviceThingName: String? = builder.coreDeviceThingName
    /**
     * The time at which the core device's status last updated, expressed in ISO 8601
     * format.
     */
    val lastStatusUpdateTimestamp: Instant? = builder.lastStatusUpdateTimestamp
    /**
     * The status of the core device. Core devices can have the following statuses:
     * HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.
     * UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state
     * on the core device.
     */
    val status: CoreDeviceStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CoreDevice = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CoreDevice(")
        append("coreDeviceThingName=$coreDeviceThingName,")
        append("lastStatusUpdateTimestamp=$lastStatusUpdateTimestamp,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = coreDeviceThingName?.hashCode() ?: 0
        result = 31 * result + (lastStatusUpdateTimestamp?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CoreDevice

        if (coreDeviceThingName != other.coreDeviceThingName) return false
        if (lastStatusUpdateTimestamp != other.lastStatusUpdateTimestamp) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CoreDevice = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CoreDevice
        /**
         * The name of the core device. This is also the name of the IoT thing.
         */
        fun coreDeviceThingName(coreDeviceThingName: String): FluentBuilder
        /**
         * The time at which the core device's status last updated, expressed in ISO 8601
         * format.
         */
        fun lastStatusUpdateTimestamp(lastStatusUpdateTimestamp: Instant): FluentBuilder
        /**
         * The status of the core device. Core devices can have the following statuses:
         * HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.
         * UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state
         * on the core device.
         */
        fun status(status: CoreDeviceStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the core device. This is also the name of the IoT thing.
         */
        var coreDeviceThingName: String?
        /**
         * The time at which the core device's status last updated, expressed in ISO 8601
         * format.
         */
        var lastStatusUpdateTimestamp: Instant?
        /**
         * The status of the core device. Core devices can have the following statuses:
         * HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.
         * UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state
         * on the core device.
         */
        var status: CoreDeviceStatus?

        fun build(): CoreDevice
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var coreDeviceThingName: String? = null
        override var lastStatusUpdateTimestamp: Instant? = null
        override var status: CoreDeviceStatus? = null

        constructor(x: CoreDevice) : this() {
            this.coreDeviceThingName = x.coreDeviceThingName
            this.lastStatusUpdateTimestamp = x.lastStatusUpdateTimestamp
            this.status = x.status
        }

        override fun build(): CoreDevice = CoreDevice(this)
        override fun coreDeviceThingName(coreDeviceThingName: String): FluentBuilder = apply { this.coreDeviceThingName = coreDeviceThingName }
        override fun lastStatusUpdateTimestamp(lastStatusUpdateTimestamp: Instant): FluentBuilder = apply { this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp }
        override fun status(status: CoreDeviceStatus): FluentBuilder = apply { this.status = status }
    }
}
