// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information system user and group that the IoT Greengrass Core software uses to run component
 * processes on the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components in the IoT Greengrass V2 Developer
 * Guide.
 */
class ComponentRunWith private constructor(builder: BuilderImpl) {
    /**
     * The POSIX system user and (optional) group to use to run this component. Specify the user
     * and group separated by a colon (:) in the following format:
     * user:group. The group is optional. If you don't specify a group, the IoT Greengrass Core
     * software uses the primary user for the group.
     * If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that
     * you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components.
     */
    val posixUser: String? = builder.posixUser
    /**
     * The system resource limits to apply to this component's process on the core device.
     * If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits
     * that you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components.
     */
    val systemResourceLimits: SystemResourceLimits? = builder.systemResourceLimits

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ComponentRunWith = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentRunWith(")
        append("posixUser=$posixUser,")
        append("systemResourceLimits=$systemResourceLimits)")
    }

    override fun hashCode(): kotlin.Int {
        var result = posixUser?.hashCode() ?: 0
        result = 31 * result + (systemResourceLimits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComponentRunWith

        if (posixUser != other.posixUser) return false
        if (systemResourceLimits != other.systemResourceLimits) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ComponentRunWith = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ComponentRunWith
        /**
         * The POSIX system user and (optional) group to use to run this component. Specify the user
         * and group separated by a colon (:) in the following format:
         * user:group. The group is optional. If you don't specify a group, the IoT Greengrass Core
         * software uses the primary user for the group.
         * If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that
         * you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components.
         */
        fun posixUser(posixUser: String): FluentBuilder
        /**
         * The system resource limits to apply to this component's process on the core device.
         * If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits
         * that you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components.
         */
        fun systemResourceLimits(systemResourceLimits: SystemResourceLimits): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The POSIX system user and (optional) group to use to run this component. Specify the user
         * and group separated by a colon (:) in the following format:
         * user:group. The group is optional. If you don't specify a group, the IoT Greengrass Core
         * software uses the primary user for the group.
         * If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that
         * you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components.
         */
        var posixUser: String?
        /**
         * The system resource limits to apply to this component's process on the core device.
         * If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits
         * that you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components.
         */
        var systemResourceLimits: SystemResourceLimits?

        fun build(): ComponentRunWith
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits] inside the given [block]
         */
        fun systemResourceLimits(block: SystemResourceLimits.DslBuilder.() -> kotlin.Unit) {
            this.systemResourceLimits = SystemResourceLimits.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var posixUser: String? = null
        override var systemResourceLimits: SystemResourceLimits? = null

        constructor(x: ComponentRunWith) : this() {
            this.posixUser = x.posixUser
            this.systemResourceLimits = x.systemResourceLimits
        }

        override fun build(): ComponentRunWith = ComponentRunWith(this)
        override fun posixUser(posixUser: String): FluentBuilder = apply { this.posixUser = posixUser }
        override fun systemResourceLimits(systemResourceLimits: SystemResourceLimits): FluentBuilder = apply { this.systemResourceLimits = systemResourceLimits }
    }
}
