// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a platform that a component supports.
 */
class ComponentPlatform private constructor(builder: BuilderImpl) {
    /**
     * A dictionary of attributes for the platform. The IoT Greengrass Core software defines the
     * os and platform by default. You can specify additional platform
     * attributes for a core device when you deploy the Greengrass nucleus component. For more information,
     * see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
     * component in the IoT Greengrass V2 Developer Guide.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * The friendly name of the platform. This name helps you identify the platform.
     * If you omit this parameter, IoT Greengrass creates a friendly name from the os and
     * architecture of the platform.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ComponentPlatform = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentPlatform(")
        append("attributes=$attributes,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComponentPlatform

        if (attributes != other.attributes) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ComponentPlatform = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ComponentPlatform
        /**
         * A dictionary of attributes for the platform. The IoT Greengrass Core software defines the
         * os and platform by default. You can specify additional platform
         * attributes for a core device when you deploy the Greengrass nucleus component. For more information,
         * see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
         * component in the IoT Greengrass V2 Developer Guide.
         */
        fun attributes(attributes: Map<String, String>): FluentBuilder
        /**
         * The friendly name of the platform. This name helps you identify the platform.
         * If you omit this parameter, IoT Greengrass creates a friendly name from the os and
         * architecture of the platform.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A dictionary of attributes for the platform. The IoT Greengrass Core software defines the
         * os and platform by default. You can specify additional platform
         * attributes for a core device when you deploy the Greengrass nucleus component. For more information,
         * see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
         * component in the IoT Greengrass V2 Developer Guide.
         */
        var attributes: Map<String, String>?
        /**
         * The friendly name of the platform. This name helps you identify the platform.
         * If you omit this parameter, IoT Greengrass creates a friendly name from the os and
         * architecture of the platform.
         */
        var name: String?

        fun build(): ComponentPlatform
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attributes: Map<String, String>? = null
        override var name: String? = null

        constructor(x: ComponentPlatform) : this() {
            this.attributes = x.attributes
            this.name = x.name
        }

        override fun build(): ComponentPlatform = ComponentPlatform(this)
        override fun attributes(attributes: Map<String, String>): FluentBuilder = apply { this.attributes = attributes }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
