// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the latest version of a component.
 */
class ComponentLatestVersion private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
     */
    val arn: String? = builder.arn
    /**
     * The version of the component.
     */
    val componentVersion: String? = builder.componentVersion
    /**
     * The time at which the component was created, expressed in ISO 8601 format.
     */
    val creationTimestamp: Instant? = builder.creationTimestamp
    /**
     * The description of the component version.
     */
    val description: String? = builder.description
    /**
     * The platforms that the component version supports.
     */
    val platforms: List<ComponentPlatform>? = builder.platforms
    /**
     * The publisher of the component version.
     */
    val publisher: String? = builder.publisher

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ComponentLatestVersion = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentLatestVersion(")
        append("arn=$arn,")
        append("componentVersion=$componentVersion,")
        append("creationTimestamp=$creationTimestamp,")
        append("description=$description,")
        append("platforms=$platforms,")
        append("publisher=$publisher)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (platforms?.hashCode() ?: 0)
        result = 31 * result + (publisher?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComponentLatestVersion

        if (arn != other.arn) return false
        if (componentVersion != other.componentVersion) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (description != other.description) return false
        if (platforms != other.platforms) return false
        if (publisher != other.publisher) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ComponentLatestVersion = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ComponentLatestVersion
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The version of the component.
         */
        fun componentVersion(componentVersion: String): FluentBuilder
        /**
         * The time at which the component was created, expressed in ISO 8601 format.
         */
        fun creationTimestamp(creationTimestamp: Instant): FluentBuilder
        /**
         * The description of the component version.
         */
        fun description(description: String): FluentBuilder
        /**
         * The platforms that the component version supports.
         */
        fun platforms(platforms: List<ComponentPlatform>): FluentBuilder
        /**
         * The publisher of the component version.
         */
        fun publisher(publisher: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        var arn: String?
        /**
         * The version of the component.
         */
        var componentVersion: String?
        /**
         * The time at which the component was created, expressed in ISO 8601 format.
         */
        var creationTimestamp: Instant?
        /**
         * The description of the component version.
         */
        var description: String?
        /**
         * The platforms that the component version supports.
         */
        var platforms: List<ComponentPlatform>?
        /**
         * The publisher of the component version.
         */
        var publisher: String?

        fun build(): ComponentLatestVersion
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var componentVersion: String? = null
        override var creationTimestamp: Instant? = null
        override var description: String? = null
        override var platforms: List<ComponentPlatform>? = null
        override var publisher: String? = null

        constructor(x: ComponentLatestVersion) : this() {
            this.arn = x.arn
            this.componentVersion = x.componentVersion
            this.creationTimestamp = x.creationTimestamp
            this.description = x.description
            this.platforms = x.platforms
            this.publisher = x.publisher
        }

        override fun build(): ComponentLatestVersion = ComponentLatestVersion(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun componentVersion(componentVersion: String): FluentBuilder = apply { this.componentVersion = componentVersion }
        override fun creationTimestamp(creationTimestamp: Instant): FluentBuilder = apply { this.creationTimestamp = creationTimestamp }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun platforms(platforms: List<ComponentPlatform>): FluentBuilder = apply { this.platforms = platforms }
        override fun publisher(publisher: String): FluentBuilder = apply { this.publisher = publisher }
    }
}
