// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a component to deploy.
 */
class ComponentDeploymentSpecification private constructor(builder: BuilderImpl) {
    /**
     * The version of the component.
     */
    val componentVersion: String? = builder.componentVersion
    /**
     * The configuration updates to deploy for the component. You can define
     * reset updates and merge updates. A reset updates
     * the keys that you specify to the default configuration for the component. A merge updates the
     * core device's component configuration with the keys and values that you specify. The IoT Greengrass Core
     * software applies reset updates before it applies merge updates. For more information, see
     * <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component
     * configurations in the IoT Greengrass V2 Developer Guide.
     */
    val configurationUpdate: ComponentConfigurationUpdate? = builder.configurationUpdate
    /**
     * The system user and group that the IoT Greengrass Core software uses to run component processes on the
     * core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group
     * that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components in the IoT Greengrass V2 Developer
     * Guide.
     */
    val runWith: ComponentRunWith? = builder.runWith

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ComponentDeploymentSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentDeploymentSpecification(")
        append("componentVersion=$componentVersion,")
        append("configurationUpdate=$configurationUpdate,")
        append("runWith=$runWith)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentVersion?.hashCode() ?: 0
        result = 31 * result + (configurationUpdate?.hashCode() ?: 0)
        result = 31 * result + (runWith?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComponentDeploymentSpecification

        if (componentVersion != other.componentVersion) return false
        if (configurationUpdate != other.configurationUpdate) return false
        if (runWith != other.runWith) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ComponentDeploymentSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ComponentDeploymentSpecification
        /**
         * The version of the component.
         */
        fun componentVersion(componentVersion: String): FluentBuilder
        /**
         * The configuration updates to deploy for the component. You can define
         * reset updates and merge updates. A reset updates
         * the keys that you specify to the default configuration for the component. A merge updates the
         * core device's component configuration with the keys and values that you specify. The IoT Greengrass Core
         * software applies reset updates before it applies merge updates. For more information, see
         * <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component
         * configurations in the IoT Greengrass V2 Developer Guide.
         */
        fun configurationUpdate(configurationUpdate: ComponentConfigurationUpdate): FluentBuilder
        /**
         * The system user and group that the IoT Greengrass Core software uses to run component processes on the
         * core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group
         * that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components in the IoT Greengrass V2 Developer
         * Guide.
         */
        fun runWith(runWith: ComponentRunWith): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The version of the component.
         */
        var componentVersion: String?
        /**
         * The configuration updates to deploy for the component. You can define
         * reset updates and merge updates. A reset updates
         * the keys that you specify to the default configuration for the component. A merge updates the
         * core device's component configuration with the keys and values that you specify. The IoT Greengrass Core
         * software applies reset updates before it applies merge updates. For more information, see
         * <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component
         * configurations in the IoT Greengrass V2 Developer Guide.
         */
        var configurationUpdate: ComponentConfigurationUpdate?
        /**
         * The system user and group that the IoT Greengrass Core software uses to run component processes on the
         * core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group
         * that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components in the IoT Greengrass V2 Developer
         * Guide.
         */
        var runWith: ComponentRunWith?

        fun build(): ComponentDeploymentSpecification
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.ComponentConfigurationUpdate] inside the given [block]
         */
        fun configurationUpdate(block: ComponentConfigurationUpdate.DslBuilder.() -> kotlin.Unit) {
            this.configurationUpdate = ComponentConfigurationUpdate.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith] inside the given [block]
         */
        fun runWith(block: ComponentRunWith.DslBuilder.() -> kotlin.Unit) {
            this.runWith = ComponentRunWith.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var componentVersion: String? = null
        override var configurationUpdate: ComponentConfigurationUpdate? = null
        override var runWith: ComponentRunWith? = null

        constructor(x: ComponentDeploymentSpecification) : this() {
            this.componentVersion = x.componentVersion
            this.configurationUpdate = x.configurationUpdate
            this.runWith = x.runWith
        }

        override fun build(): ComponentDeploymentSpecification = ComponentDeploymentSpecification(this)
        override fun componentVersion(componentVersion: String): FluentBuilder = apply { this.componentVersion = componentVersion }
        override fun configurationUpdate(configurationUpdate: ComponentConfigurationUpdate): FluentBuilder = apply { this.configurationUpdate = configurationUpdate }
        override fun runWith(runWith: ComponentRunWith): FluentBuilder = apply { this.runWith = runWith }
    }
}
