// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a component dependency for a Lambda function component.
 */
class ComponentDependencyRequirement private constructor(builder: BuilderImpl) {
    /**
     * The type of this dependency. Choose from the following options:
     * SOFT – The component doesn't restart if the dependency changes
     * state.
     * HARD – The component restarts if the dependency changes
     * state.
     * Default: HARD
     */
    val dependencyType: ComponentDependencyType? = builder.dependencyType
    /**
     * The component version requirement for the component dependency.
     * IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning.
     */
    val versionRequirement: String? = builder.versionRequirement

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ComponentDependencyRequirement = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentDependencyRequirement(")
        append("dependencyType=$dependencyType,")
        append("versionRequirement=$versionRequirement)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dependencyType?.hashCode() ?: 0
        result = 31 * result + (versionRequirement?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComponentDependencyRequirement

        if (dependencyType != other.dependencyType) return false
        if (versionRequirement != other.versionRequirement) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ComponentDependencyRequirement = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ComponentDependencyRequirement
        /**
         * The type of this dependency. Choose from the following options:
         * SOFT – The component doesn't restart if the dependency changes
         * state.
         * HARD – The component restarts if the dependency changes
         * state.
         * Default: HARD
         */
        fun dependencyType(dependencyType: ComponentDependencyType): FluentBuilder
        /**
         * The component version requirement for the component dependency.
         * IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning.
         */
        fun versionRequirement(versionRequirement: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of this dependency. Choose from the following options:
         * SOFT – The component doesn't restart if the dependency changes
         * state.
         * HARD – The component restarts if the dependency changes
         * state.
         * Default: HARD
         */
        var dependencyType: ComponentDependencyType?
        /**
         * The component version requirement for the component dependency.
         * IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning.
         */
        var versionRequirement: String?

        fun build(): ComponentDependencyRequirement
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dependencyType: ComponentDependencyType? = null
        override var versionRequirement: String? = null

        constructor(x: ComponentDependencyRequirement) : this() {
            this.dependencyType = x.dependencyType
            this.versionRequirement = x.versionRequirement
        }

        override fun build(): ComponentDependencyRequirement = ComponentDependencyRequirement(this)
        override fun dependencyType(dependencyType: ComponentDependencyType): FluentBuilder = apply { this.dependencyType = dependencyType }
        override fun versionRequirement(versionRequirement: String): FluentBuilder = apply { this.versionRequirement = versionRequirement }
    }
}
