// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a deployment's update to a component's configuration on
 * Greengrass core devices. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component
 * configurations in the IoT Greengrass V2 Developer Guide.
 */
class ComponentConfigurationUpdate private constructor(builder: BuilderImpl) {
    /**
     * A serialized JSON string that contains the configuration object to merge to target
     * devices. The core device merges this configuration with the component's existing
     * configuration. If this is the first time a component deploys on a device, the core device
     * merges this configuration with the component's default configuration. This means that the core
     * device keeps it's existing configuration for keys and values that you don't specify in this
     * object. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update">Merge configuration updates in the IoT Greengrass V2 Developer
     * Guide.
     */
    val merge: String? = builder.merge
    /**
     * The list of configuration nodes to reset to default values on target devices. Use JSON
     * pointers to specify each node to reset. JSON pointers start with a forward slash
     * (/) and use forward slashes to separate the key for each level in the object.
     * For more information, see the <a href="https://tools.ietf.org/html/rfc6901">JSON pointer
     * specification and <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update">Reset configuration updates in the IoT Greengrass V2 Developer
     * Guide.
     */
    val reset: List<String>? = builder.reset

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ComponentConfigurationUpdate = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentConfigurationUpdate(")
        append("merge=$merge,")
        append("reset=$reset)")
    }

    override fun hashCode(): kotlin.Int {
        var result = merge?.hashCode() ?: 0
        result = 31 * result + (reset?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComponentConfigurationUpdate

        if (merge != other.merge) return false
        if (reset != other.reset) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ComponentConfigurationUpdate = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ComponentConfigurationUpdate
        /**
         * A serialized JSON string that contains the configuration object to merge to target
         * devices. The core device merges this configuration with the component's existing
         * configuration. If this is the first time a component deploys on a device, the core device
         * merges this configuration with the component's default configuration. This means that the core
         * device keeps it's existing configuration for keys and values that you don't specify in this
         * object. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update">Merge configuration updates in the IoT Greengrass V2 Developer
         * Guide.
         */
        fun merge(merge: String): FluentBuilder
        /**
         * The list of configuration nodes to reset to default values on target devices. Use JSON
         * pointers to specify each node to reset. JSON pointers start with a forward slash
         * (/) and use forward slashes to separate the key for each level in the object.
         * For more information, see the <a href="https://tools.ietf.org/html/rfc6901">JSON pointer
         * specification and <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update">Reset configuration updates in the IoT Greengrass V2 Developer
         * Guide.
         */
        fun reset(reset: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A serialized JSON string that contains the configuration object to merge to target
         * devices. The core device merges this configuration with the component's existing
         * configuration. If this is the first time a component deploys on a device, the core device
         * merges this configuration with the component's default configuration. This means that the core
         * device keeps it's existing configuration for keys and values that you don't specify in this
         * object. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update">Merge configuration updates in the IoT Greengrass V2 Developer
         * Guide.
         */
        var merge: String?
        /**
         * The list of configuration nodes to reset to default values on target devices. Use JSON
         * pointers to specify each node to reset. JSON pointers start with a forward slash
         * (/) and use forward slashes to separate the key for each level in the object.
         * For more information, see the <a href="https://tools.ietf.org/html/rfc6901">JSON pointer
         * specification and <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update">Reset configuration updates in the IoT Greengrass V2 Developer
         * Guide.
         */
        var reset: List<String>?

        fun build(): ComponentConfigurationUpdate
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var merge: String? = null
        override var reset: List<String>? = null

        constructor(x: ComponentConfigurationUpdate) : this() {
            this.merge = x.merge
            this.reset = x.reset
        }

        override fun build(): ComponentConfigurationUpdate = ComponentConfigurationUpdate(this)
        override fun merge(merge: String): FluentBuilder = apply { this.merge = merge }
        override fun reset(reset: List<String>): FluentBuilder = apply { this.reset = reset }
    }
}
