// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a component that is a candidate to deploy to a Greengrass core
 * device.
 */
class ComponentCandidate private constructor(builder: BuilderImpl) {
    /**
     * The name of the component.
     */
    val componentName: String? = builder.componentName
    /**
     * The version of the component.
     */
    val componentVersion: String? = builder.componentVersion
    /**
     * The version requirements for the component's dependencies. Greengrass core devices get the
     * version requirements from component recipes.
     * IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning.
     */
    val versionRequirements: Map<String, String>? = builder.versionRequirements

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ComponentCandidate = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentCandidate(")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("versionRequirements=$versionRequirements)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentName?.hashCode() ?: 0
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (versionRequirements?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComponentCandidate

        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (versionRequirements != other.versionRequirements) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ComponentCandidate = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ComponentCandidate
        /**
         * The name of the component.
         */
        fun componentName(componentName: String): FluentBuilder
        /**
         * The version of the component.
         */
        fun componentVersion(componentVersion: String): FluentBuilder
        /**
         * The version requirements for the component's dependencies. Greengrass core devices get the
         * version requirements from component recipes.
         * IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning.
         */
        fun versionRequirements(versionRequirements: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the component.
         */
        var componentName: String?
        /**
         * The version of the component.
         */
        var componentVersion: String?
        /**
         * The version requirements for the component's dependencies. Greengrass core devices get the
         * version requirements from component recipes.
         * IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning.
         */
        var versionRequirements: Map<String, String>?

        fun build(): ComponentCandidate
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var componentName: String? = null
        override var componentVersion: String? = null
        override var versionRequirements: Map<String, String>? = null

        constructor(x: ComponentCandidate) : this() {
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.versionRequirements = x.versionRequirements
        }

        override fun build(): ComponentCandidate = ComponentCandidate(this)
        override fun componentName(componentName: String): FluentBuilder = apply { this.componentName = componentName }
        override fun componentVersion(componentVersion: String): FluentBuilder = apply { this.componentVersion = componentVersion }
        override fun versionRequirements(versionRequirements: Map<String, String>): FluentBuilder = apply { this.versionRequirements = versionRequirements }
    }
}
