// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a component.
 */
class Component private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
     */
    val arn: String? = builder.arn
    /**
     * The name of the component.
     */
    val componentName: String? = builder.componentName
    /**
     * The latest version of the component and its details.
     */
    val latestVersion: ComponentLatestVersion? = builder.latestVersion

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Component = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Component(")
        append("arn=$arn,")
        append("componentName=$componentName,")
        append("latestVersion=$latestVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (latestVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Component

        if (arn != other.arn) return false
        if (componentName != other.componentName) return false
        if (latestVersion != other.latestVersion) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Component = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Component
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun componentName(componentName: String): FluentBuilder
        /**
         * The latest version of the component and its details.
         */
        fun latestVersion(latestVersion: ComponentLatestVersion): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the component version.
         */
        var arn: String?
        /**
         * The name of the component.
         */
        var componentName: String?
        /**
         * The latest version of the component and its details.
         */
        var latestVersion: ComponentLatestVersion?

        fun build(): Component
        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.ComponentLatestVersion] inside the given [block]
         */
        fun latestVersion(block: ComponentLatestVersion.DslBuilder.() -> kotlin.Unit) {
            this.latestVersion = ComponentLatestVersion.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var componentName: String? = null
        override var latestVersion: ComponentLatestVersion? = null

        constructor(x: Component) : this() {
            this.arn = x.arn
            this.componentName = x.componentName
            this.latestVersion = x.latestVersion
        }

        override fun build(): Component = Component(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun componentName(componentName: String): FluentBuilder = apply { this.componentName = componentName }
        override fun latestVersion(latestVersion: ComponentLatestVersion): FluentBuilder = apply { this.latestVersion = latestVersion }
    }
}
