// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains the status of a component in the IoT Greengrass service.
 */
class CloudComponentStatus private constructor(builder: BuilderImpl) {
    /**
     * The state of the component.
     */
    val componentState: CloudComponentState? = builder.componentState
    /**
     * A dictionary of errors that communicate why the component is in an error state. For
     * example, if IoT Greengrass can't access an artifact for the component, then errors contains
     * the artifact's URI as a key, and the error message as the value for that key.
     */
    val errors: Map<String, String>? = builder.errors
    /**
     * A message that communicates details, such as errors, about the status of the component.
     */
    val message: String? = builder.message

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CloudComponentStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CloudComponentStatus(")
        append("componentState=$componentState,")
        append("errors=$errors,")
        append("message=$message)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentState?.hashCode() ?: 0
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CloudComponentStatus

        if (componentState != other.componentState) return false
        if (errors != other.errors) return false
        if (message != other.message) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CloudComponentStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CloudComponentStatus
        /**
         * The state of the component.
         */
        fun componentState(componentState: CloudComponentState): FluentBuilder
        /**
         * A dictionary of errors that communicate why the component is in an error state. For
         * example, if IoT Greengrass can't access an artifact for the component, then errors contains
         * the artifact's URI as a key, and the error message as the value for that key.
         */
        fun errors(errors: Map<String, String>): FluentBuilder
        /**
         * A message that communicates details, such as errors, about the status of the component.
         */
        fun message(message: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The state of the component.
         */
        var componentState: CloudComponentState?
        /**
         * A dictionary of errors that communicate why the component is in an error state. For
         * example, if IoT Greengrass can't access an artifact for the component, then errors contains
         * the artifact's URI as a key, and the error message as the value for that key.
         */
        var errors: Map<String, String>?
        /**
         * A message that communicates details, such as errors, about the status of the component.
         */
        var message: String?

        fun build(): CloudComponentStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var componentState: CloudComponentState? = null
        override var errors: Map<String, String>? = null
        override var message: String? = null

        constructor(x: CloudComponentStatus) : this() {
            this.componentState = x.componentState
            this.errors = x.errors
            this.message = x.message
        }

        override fun build(): CloudComponentStatus = CloudComponentStatus(this)
        override fun componentState(componentState: CloudComponentState): FluentBuilder = apply { this.componentState = componentState }
        override fun errors(errors: Map<String, String>): FluentBuilder = apply { this.errors = errors }
        override fun message(message: String): FluentBuilder = apply { this.message = message }
    }
}
