// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a client device that is associated to a core device for cloud
 * discovery.
 */
class AssociatedClientDevice private constructor(builder: BuilderImpl) {
    /**
     * The time that the client device was associated, expressed in ISO 8601 format.
     */
    val associationTimestamp: Instant? = builder.associationTimestamp
    /**
     * The name of the IoT thing that represents the associated client device.
     */
    val thingName: String? = builder.thingName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssociatedClientDevice = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssociatedClientDevice(")
        append("associationTimestamp=$associationTimestamp,")
        append("thingName=$thingName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationTimestamp?.hashCode() ?: 0
        result = 31 * result + (thingName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssociatedClientDevice

        if (associationTimestamp != other.associationTimestamp) return false
        if (thingName != other.thingName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssociatedClientDevice = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssociatedClientDevice
        /**
         * The time that the client device was associated, expressed in ISO 8601 format.
         */
        fun associationTimestamp(associationTimestamp: Instant): FluentBuilder
        /**
         * The name of the IoT thing that represents the associated client device.
         */
        fun thingName(thingName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time that the client device was associated, expressed in ISO 8601 format.
         */
        var associationTimestamp: Instant?
        /**
         * The name of the IoT thing that represents the associated client device.
         */
        var thingName: String?

        fun build(): AssociatedClientDevice
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associationTimestamp: Instant? = null
        override var thingName: String? = null

        constructor(x: AssociatedClientDevice) : this() {
            this.associationTimestamp = x.associationTimestamp
            this.thingName = x.thingName
        }

        override fun build(): AssociatedClientDevice = AssociatedClientDevice(this)
        override fun associationTimestamp(associationTimestamp: Instant): FluentBuilder = apply { this.associationTimestamp = associationTimestamp }
        override fun thingName(thingName: String): FluentBuilder = apply { this.thingName = thingName }
    }
}
