// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.services.greengrassv2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.greengrassv2.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * IoT Greengrass brings local compute, messaging, data management, sync, and ML inference capabilities
 * to edge devices. This enables devices to collect and analyze data closer to the source of
 * information, react autonomously to local events, and communicate securely with each other on
 * local networks. Local devices can also communicate securely with Amazon Web Services IoT Core and export IoT data
 * to the Amazon Web Services Cloud. IoT Greengrass developers can use Lambda functions and components to create and
 * deploy applications to fleets of edge devices for local operation.
 * IoT Greengrass Version 2 provides a new major version of the IoT Greengrass Core software, new APIs, and a new console.
 * Use this API reference to learn how to use the IoT Greengrass V2 API operations to manage components,
 * manage deployments, and core devices.
 * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/what-is-iot-greengrass.html">What is IoT Greengrass? in
 * the IoT Greengrass V2 Developer Guide.
 */
interface GreengrassV2Client : SdkClient {

    override val serviceName: String
        get() = "GreengrassV2"
    /**
     * GreengrassV2Client's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): GreengrassV2Client {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultGreengrassV2Client(config)
        }

        operator fun invoke(config: Config): GreengrassV2Client = DefaultGreengrassV2Client(config)

        /**
         * Construct a [GreengrassV2Client] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): GreengrassV2Client {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return GreengrassV2Client(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: EndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Associate a list of client devices with a core device. Use this API operation to specify
     * which client devices can discover a core device through cloud discovery. With cloud discovery,
     * client devices connect to IoT Greengrass to retrieve associated core devices' connectivity information
     * and certificates. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html">Configure cloud
     * discovery in the IoT Greengrass V2 Developer Guide.
     * Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core
     * device over MQTT. You can connect client devices to a core device to sync MQTT messages and
     * data to Amazon Web Services IoT Core and interact with client devices in Greengrass components. For more information,
     * see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html">Interact with
     * local IoT devices in the IoT Greengrass V2 Developer Guide.
     */
    suspend fun batchAssociateClientDeviceWithCoreDevice(input: BatchAssociateClientDeviceWithCoreDeviceRequest): BatchAssociateClientDeviceWithCoreDeviceResponse

    /**
     * Associate a list of client devices with a core device. Use this API operation to specify
     * which client devices can discover a core device through cloud discovery. With cloud discovery,
     * client devices connect to IoT Greengrass to retrieve associated core devices' connectivity information
     * and certificates. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html">Configure cloud
     * discovery in the IoT Greengrass V2 Developer Guide.
     * Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core
     * device over MQTT. You can connect client devices to a core device to sync MQTT messages and
     * data to Amazon Web Services IoT Core and interact with client devices in Greengrass components. For more information,
     * see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html">Interact with
     * local IoT devices in the IoT Greengrass V2 Developer Guide.
     */
    suspend fun batchAssociateClientDeviceWithCoreDevice(block: BatchAssociateClientDeviceWithCoreDeviceRequest.DslBuilder.() -> Unit) = batchAssociateClientDeviceWithCoreDevice(BatchAssociateClientDeviceWithCoreDeviceRequest.builder().apply(block).build())

    /**
     * Disassociate a list of client devices from a core device. After you disassociate a client
     * device from a core device, the client device won't be able to use cloud discovery to retrieve
     * the core device's connectivity information and certificates.
     */
    suspend fun batchDisassociateClientDeviceFromCoreDevice(input: BatchDisassociateClientDeviceFromCoreDeviceRequest): BatchDisassociateClientDeviceFromCoreDeviceResponse

    /**
     * Disassociate a list of client devices from a core device. After you disassociate a client
     * device from a core device, the client device won't be able to use cloud discovery to retrieve
     * the core device's connectivity information and certificates.
     */
    suspend fun batchDisassociateClientDeviceFromCoreDevice(block: BatchDisassociateClientDeviceFromCoreDeviceRequest.DslBuilder.() -> Unit) = batchDisassociateClientDeviceFromCoreDevice(BatchDisassociateClientDeviceFromCoreDeviceRequest.builder().apply(block).build())

    /**
     * Cancels a deployment. This operation cancels the deployment for devices that haven't yet
     * received it. If a device already received the deployment, this operation doesn't change
     * anything for that device.
     */
    suspend fun cancelDeployment(input: CancelDeploymentRequest): CancelDeploymentResponse

    /**
     * Cancels a deployment. This operation cancels the deployment for devices that haven't yet
     * received it. If a device already received the deployment, this operation doesn't change
     * anything for that device.
     */
    suspend fun cancelDeployment(block: CancelDeploymentRequest.DslBuilder.() -> Unit) = cancelDeployment(CancelDeploymentRequest.builder().apply(block).build())

    /**
     * Creates a component. Components are software that run on Greengrass core devices. After you
     * develop and test a component on your core device, you can use this operation to upload your
     * component to IoT Greengrass. Then, you can deploy the component to other core devices.
     * You can use this operation to do the following:
     * Create components from recipes
     * Create a component from a recipe, which is a file that defines the component's
     * metadata, parameters, dependencies, lifecycle, artifacts, and platform capability. For
     * more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html">IoT Greengrass component recipe
     * reference in the IoT Greengrass V2 Developer Guide.
     * To create a component from a recipe, specify inlineRecipe when you call
     * this operation.
     * Create components from Lambda functions
     * Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe
     * and artifacts from the Lambda function's deployment package. You can use this operation to
     * migrate Lambda functions from IoT Greengrass V1 to IoT Greengrass V2.
     * This function only accepts Lambda functions that use the following runtimes:
     * Python 2.7 – python2.7
     * Python 3.7 – python3.7
     * Python 3.8 – python3.8
     * Java 8 – java8
     * Node.js 10 – nodejs10.x
     * Node.js 12 – nodejs12.x
     * To create a component from a Lambda function, specify lambdaFunction
     * when you call this operation.
     */
    suspend fun createComponentVersion(input: CreateComponentVersionRequest): CreateComponentVersionResponse

    /**
     * Creates a component. Components are software that run on Greengrass core devices. After you
     * develop and test a component on your core device, you can use this operation to upload your
     * component to IoT Greengrass. Then, you can deploy the component to other core devices.
     * You can use this operation to do the following:
     * Create components from recipes
     * Create a component from a recipe, which is a file that defines the component's
     * metadata, parameters, dependencies, lifecycle, artifacts, and platform capability. For
     * more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html">IoT Greengrass component recipe
     * reference in the IoT Greengrass V2 Developer Guide.
     * To create a component from a recipe, specify inlineRecipe when you call
     * this operation.
     * Create components from Lambda functions
     * Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe
     * and artifacts from the Lambda function's deployment package. You can use this operation to
     * migrate Lambda functions from IoT Greengrass V1 to IoT Greengrass V2.
     * This function only accepts Lambda functions that use the following runtimes:
     * Python 2.7 – python2.7
     * Python 3.7 – python3.7
     * Python 3.8 – python3.8
     * Java 8 – java8
     * Node.js 10 – nodejs10.x
     * Node.js 12 – nodejs12.x
     * To create a component from a Lambda function, specify lambdaFunction
     * when you call this operation.
     */
    suspend fun createComponentVersion(block: CreateComponentVersionRequest.DslBuilder.() -> Unit) = createComponentVersion(CreateComponentVersionRequest.builder().apply(block).build())

    /**
     * Creates a continuous deployment for a target, which is a Greengrass core device or group of core
     * devices. When you add a new core device to a group of core devices that has a deployment, IoT Greengrass
     * deploys that group's deployment to the new device.
     * You can define one deployment for each target. When you create a new deployment for a
     * target that has an existing deployment, you replace the previous deployment. IoT Greengrass applies the
     * new deployment to the target devices.
     * Every deployment has a revision number that indicates how many deployment revisions you
     * define for a target. Use this operation to create a new revision of an existing deployment.
     * This operation returns the revision number of the new deployment when you create it.
     * For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments in the
     * IoT Greengrass V2 Developer Guide.
     */
    suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Creates a continuous deployment for a target, which is a Greengrass core device or group of core
     * devices. When you add a new core device to a group of core devices that has a deployment, IoT Greengrass
     * deploys that group's deployment to the new device.
     * You can define one deployment for each target. When you create a new deployment for a
     * target that has an existing deployment, you replace the previous deployment. IoT Greengrass applies the
     * new deployment to the target devices.
     * Every deployment has a revision number that indicates how many deployment revisions you
     * define for a target. Use this operation to create a new revision of an existing deployment.
     * This operation returns the revision number of the new deployment when you create it.
     * For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments in the
     * IoT Greengrass V2 Developer Guide.
     */
    suspend fun createDeployment(block: CreateDeploymentRequest.DslBuilder.() -> Unit) = createDeployment(CreateDeploymentRequest.builder().apply(block).build())

    /**
     * Deletes a version of a component from IoT Greengrass.
     * This operation deletes the component's recipe and artifacts. As a result, deployments
     * that refer to this component version will fail. If you have deployments that use this
     * component version, you can remove the component from the deployment or update the deployment
     * to use a valid version.
     */
    suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Deletes a version of a component from IoT Greengrass.
     * This operation deletes the component's recipe and artifacts. As a result, deployments
     * that refer to this component version will fail. If you have deployments that use this
     * component version, you can remove the component from the deployment or update the deployment
     * to use a valid version.
     */
    suspend fun deleteComponent(block: DeleteComponentRequest.DslBuilder.() -> Unit) = deleteComponent(DeleteComponentRequest.builder().apply(block).build())

    /**
     * Deletes a Greengrass core device, which is an IoT thing. This operation removes the core
     * device from the list of core devices. This operation doesn't delete the IoT thing. For more
     * information about how to delete the IoT thing, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html">DeleteThing in the
     * IoT API Reference.
     */
    suspend fun deleteCoreDevice(input: DeleteCoreDeviceRequest): DeleteCoreDeviceResponse

    /**
     * Deletes a Greengrass core device, which is an IoT thing. This operation removes the core
     * device from the list of core devices. This operation doesn't delete the IoT thing. For more
     * information about how to delete the IoT thing, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html">DeleteThing in the
     * IoT API Reference.
     */
    suspend fun deleteCoreDevice(block: DeleteCoreDeviceRequest.DslBuilder.() -> Unit) = deleteCoreDevice(DeleteCoreDeviceRequest.builder().apply(block).build())

    /**
     * Retrieves metadata for a version of a component.
     */
    suspend fun describeComponent(input: DescribeComponentRequest): DescribeComponentResponse

    /**
     * Retrieves metadata for a version of a component.
     */
    suspend fun describeComponent(block: DescribeComponentRequest.DslBuilder.() -> Unit) = describeComponent(DescribeComponentRequest.builder().apply(block).build())

    /**
     * Gets the recipe for a version of a component. Core devices can call this operation to
     * identify the artifacts and requirements to install a component.
     */
    suspend fun getComponent(input: GetComponentRequest): GetComponentResponse

    /**
     * Gets the recipe for a version of a component. Core devices can call this operation to
     * identify the artifacts and requirements to install a component.
     */
    suspend fun getComponent(block: GetComponentRequest.DslBuilder.() -> Unit) = getComponent(GetComponentRequest.builder().apply(block).build())

    /**
     * Gets the pre-signed URL to download a public component artifact. Core devices call this
     * operation to identify the URL that they can use to download an artifact to install.
     */
    suspend fun getComponentVersionArtifact(input: GetComponentVersionArtifactRequest): GetComponentVersionArtifactResponse

    /**
     * Gets the pre-signed URL to download a public component artifact. Core devices call this
     * operation to identify the URL that they can use to download an artifact to install.
     */
    suspend fun getComponentVersionArtifact(block: GetComponentVersionArtifactRequest.DslBuilder.() -> Unit) = getComponentVersionArtifact(GetComponentVersionArtifactRequest.builder().apply(block).build())

    /**
     * Retrieves metadata for a Greengrass core device.
     */
    suspend fun getCoreDevice(input: GetCoreDeviceRequest): GetCoreDeviceResponse

    /**
     * Retrieves metadata for a Greengrass core device.
     */
    suspend fun getCoreDevice(block: GetCoreDeviceRequest.DslBuilder.() -> Unit) = getCoreDevice(GetCoreDeviceRequest.builder().apply(block).build())

    /**
     * Gets a deployment. Deployments define the components that run on Greengrass core devices.
     */
    suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse

    /**
     * Gets a deployment. Deployments define the components that run on Greengrass core devices.
     */
    suspend fun getDeployment(block: GetDeploymentRequest.DslBuilder.() -> Unit) = getDeployment(GetDeploymentRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of client devices that are associated with a core
     * device.
     */
    suspend fun listClientDevicesAssociatedWithCoreDevice(input: ListClientDevicesAssociatedWithCoreDeviceRequest): ListClientDevicesAssociatedWithCoreDeviceResponse

    /**
     * Retrieves a paginated list of client devices that are associated with a core
     * device.
     */
    suspend fun listClientDevicesAssociatedWithCoreDevice(block: ListClientDevicesAssociatedWithCoreDeviceRequest.DslBuilder.() -> Unit) = listClientDevicesAssociatedWithCoreDevice(ListClientDevicesAssociatedWithCoreDeviceRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of all versions for a component. Greater versions are listed first.
     */
    suspend fun listComponentVersions(input: ListComponentVersionsRequest): ListComponentVersionsResponse

    /**
     * Retrieves a paginated list of all versions for a component. Greater versions are listed first.
     */
    suspend fun listComponentVersions(block: ListComponentVersionsRequest.DslBuilder.() -> Unit) = listComponentVersions(ListComponentVersionsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of component summaries. This list includes components that you
     * have permission to view.
     */
    suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse

    /**
     * Retrieves a paginated list of component summaries. This list includes components that you
     * have permission to view.
     */
    suspend fun listComponents(block: ListComponentsRequest.DslBuilder.() -> Unit) = listComponents(ListComponentsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of Greengrass core devices.
     */
    suspend fun listCoreDevices(input: ListCoreDevicesRequest): ListCoreDevicesResponse

    /**
     * Retrieves a paginated list of Greengrass core devices.
     */
    suspend fun listCoreDevices(block: ListCoreDevicesRequest.DslBuilder.() -> Unit) = listCoreDevices(ListCoreDevicesRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of deployments.
     */
    suspend fun listDeployments(input: ListDeploymentsRequest): ListDeploymentsResponse

    /**
     * Retrieves a paginated list of deployments.
     */
    suspend fun listDeployments(block: ListDeploymentsRequest.DslBuilder.() -> Unit) = listDeployments(ListDeploymentsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core
     * devices.
     */
    suspend fun listEffectiveDeployments(input: ListEffectiveDeploymentsRequest): ListEffectiveDeploymentsResponse

    /**
     * Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core
     * devices.
     */
    suspend fun listEffectiveDeployments(block: ListEffectiveDeploymentsRequest.DslBuilder.() -> Unit) = listEffectiveDeployments(ListEffectiveDeploymentsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of the components that a Greengrass core device runs.
     */
    suspend fun listInstalledComponents(input: ListInstalledComponentsRequest): ListInstalledComponentsResponse

    /**
     * Retrieves a paginated list of the components that a Greengrass core device runs.
     */
    suspend fun listInstalledComponents(block: ListInstalledComponentsRequest.DslBuilder.() -> Unit) = listInstalledComponents(ListInstalledComponentsRequest.builder().apply(block).build())

    /**
     * Retrieves the list of tags for an IoT Greengrass resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves the list of tags for an IoT Greengrass resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Retrieves a list of components that meet the component, version, and platform requirements
     * of a deployment. Greengrass core devices call this operation when they receive a deployment to
     * identify the components to install.
     * This operation identifies components that meet all dependency requirements for a
     * deployment. If the requirements conflict, then this operation returns an error and the
     * deployment fails. For example, this occurs if component A requires version
     * >2.0.0 and component B requires version <2.0.0
     * of a component dependency.
     * When you specify the component candidates to resolve, IoT Greengrass compares each component's
     * digest from the core device with the component's digest in the Amazon Web Services Cloud. If the digests don't
     * match, then IoT Greengrass specifies to use the version from the Amazon Web Services Cloud.
     * To use this operation, you must use the data plane API endpoint and authenticate with an
     * IoT device certificate. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/greengrass.html">IoT Greengrass endpoints and quotas.
     */
    suspend fun resolveComponentCandidates(input: ResolveComponentCandidatesRequest): ResolveComponentCandidatesResponse

    /**
     * Retrieves a list of components that meet the component, version, and platform requirements
     * of a deployment. Greengrass core devices call this operation when they receive a deployment to
     * identify the components to install.
     * This operation identifies components that meet all dependency requirements for a
     * deployment. If the requirements conflict, then this operation returns an error and the
     * deployment fails. For example, this occurs if component A requires version
     * >2.0.0 and component B requires version <2.0.0
     * of a component dependency.
     * When you specify the component candidates to resolve, IoT Greengrass compares each component's
     * digest from the core device with the component's digest in the Amazon Web Services Cloud. If the digests don't
     * match, then IoT Greengrass specifies to use the version from the Amazon Web Services Cloud.
     * To use this operation, you must use the data plane API endpoint and authenticate with an
     * IoT device certificate. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/greengrass.html">IoT Greengrass endpoints and quotas.
     */
    suspend fun resolveComponentCandidates(block: ResolveComponentCandidatesRequest.DslBuilder.() -> Unit) = resolveComponentCandidates(ResolveComponentCandidatesRequest.builder().apply(block).build())

    /**
     * Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this operation
     * updates the tag's value.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this operation
     * updates the tag's value.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes a tag from an IoT Greengrass resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from an IoT Greengrass resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())
}
