// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.greengrassv2.model.*
import aws.sdk.kotlin.services.greengrassv2.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "GreengrassV2"
const val ServiceApiVersion: String = "2020-11-30"
const val SdkVersion: String = "0.8.0-alpha"

internal class DefaultGreengrassV2Client(override val config: GreengrassV2Client.Config) : GreengrassV2Client {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Associate a list of client devices with a core device. Use this API operation to specify
     * which client devices can discover a core device through cloud discovery. With cloud discovery,
     * client devices connect to IoT Greengrass to retrieve associated core devices' connectivity information
     * and certificates. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html">Configure cloud
     * discovery in the IoT Greengrass V2 Developer Guide.
     * Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core
     * device over MQTT. You can connect client devices to a core device to sync MQTT messages and
     * data to Amazon Web Services IoT Core and interact with client devices in Greengrass components. For more information,
     * see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html">Interact with
     * local IoT devices in the IoT Greengrass V2 Developer Guide.
     */
    override suspend fun batchAssociateClientDeviceWithCoreDevice(input: BatchAssociateClientDeviceWithCoreDeviceRequest): BatchAssociateClientDeviceWithCoreDeviceResponse {
        val op = SdkHttpOperation.build<BatchAssociateClientDeviceWithCoreDeviceRequest, BatchAssociateClientDeviceWithCoreDeviceResponse> {
            serializer = BatchAssociateClientDeviceWithCoreDeviceOperationSerializer()
            deserializer = BatchAssociateClientDeviceWithCoreDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchAssociateClientDeviceWithCoreDevice"
            }
        }
        registerBatchAssociateClientDeviceWithCoreDeviceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociate a list of client devices from a core device. After you disassociate a client
     * device from a core device, the client device won't be able to use cloud discovery to retrieve
     * the core device's connectivity information and certificates.
     */
    override suspend fun batchDisassociateClientDeviceFromCoreDevice(input: BatchDisassociateClientDeviceFromCoreDeviceRequest): BatchDisassociateClientDeviceFromCoreDeviceResponse {
        val op = SdkHttpOperation.build<BatchDisassociateClientDeviceFromCoreDeviceRequest, BatchDisassociateClientDeviceFromCoreDeviceResponse> {
            serializer = BatchDisassociateClientDeviceFromCoreDeviceOperationSerializer()
            deserializer = BatchDisassociateClientDeviceFromCoreDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisassociateClientDeviceFromCoreDevice"
            }
        }
        registerBatchDisassociateClientDeviceFromCoreDeviceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a deployment. This operation cancels the deployment for devices that haven't yet
     * received it. If a device already received the deployment, this operation doesn't change
     * anything for that device.
     */
    override suspend fun cancelDeployment(input: CancelDeploymentRequest): CancelDeploymentResponse {
        val op = SdkHttpOperation.build<CancelDeploymentRequest, CancelDeploymentResponse> {
            serializer = CancelDeploymentOperationSerializer()
            deserializer = CancelDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelDeployment"
            }
        }
        registerCancelDeploymentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a component. Components are software that run on Greengrass core devices. After you
     * develop and test a component on your core device, you can use this operation to upload your
     * component to IoT Greengrass. Then, you can deploy the component to other core devices.
     * You can use this operation to do the following:
     * Create components from recipes
     * Create a component from a recipe, which is a file that defines the component's
     * metadata, parameters, dependencies, lifecycle, artifacts, and platform capability. For
     * more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html">IoT Greengrass component recipe
     * reference in the IoT Greengrass V2 Developer Guide.
     * To create a component from a recipe, specify inlineRecipe when you call
     * this operation.
     * Create components from Lambda functions
     * Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe
     * and artifacts from the Lambda function's deployment package. You can use this operation to
     * migrate Lambda functions from IoT Greengrass V1 to IoT Greengrass V2.
     * This function only accepts Lambda functions that use the following runtimes:
     * Python 2.7 – python2.7
     * Python 3.7 – python3.7
     * Python 3.8 – python3.8
     * Java 8 – java8
     * Node.js 10 – nodejs10.x
     * Node.js 12 – nodejs12.x
     * To create a component from a Lambda function, specify lambdaFunction
     * when you call this operation.
     */
    override suspend fun createComponentVersion(input: CreateComponentVersionRequest): CreateComponentVersionResponse {
        val op = SdkHttpOperation.build<CreateComponentVersionRequest, CreateComponentVersionResponse> {
            serializer = CreateComponentVersionOperationSerializer()
            deserializer = CreateComponentVersionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateComponentVersion"
            }
        }
        registerCreateComponentVersionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a continuous deployment for a target, which is a Greengrass core device or group of core
     * devices. When you add a new core device to a group of core devices that has a deployment, IoT Greengrass
     * deploys that group's deployment to the new device.
     * You can define one deployment for each target. When you create a new deployment for a
     * target that has an existing deployment, you replace the previous deployment. IoT Greengrass applies the
     * new deployment to the target devices.
     * Every deployment has a revision number that indicates how many deployment revisions you
     * define for a target. Use this operation to create a new revision of an existing deployment.
     * This operation returns the revision number of the new deployment when you create it.
     * For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments in the
     * IoT Greengrass V2 Developer Guide.
     */
    override suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse {
        val op = SdkHttpOperation.build<CreateDeploymentRequest, CreateDeploymentResponse> {
            serializer = CreateDeploymentOperationSerializer()
            deserializer = CreateDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDeployment"
            }
        }
        registerCreateDeploymentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a version of a component from IoT Greengrass.
     * This operation deletes the component's recipe and artifacts. As a result, deployments
     * that refer to this component version will fail. If you have deployments that use this
     * component version, you can remove the component from the deployment or update the deployment
     * to use a valid version.
     */
    override suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse {
        val op = SdkHttpOperation.build<DeleteComponentRequest, DeleteComponentResponse> {
            serializer = DeleteComponentOperationSerializer()
            deserializer = DeleteComponentOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteComponent"
            }
        }
        registerDeleteComponentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Greengrass core device, which is an IoT thing. This operation removes the core
     * device from the list of core devices. This operation doesn't delete the IoT thing. For more
     * information about how to delete the IoT thing, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html">DeleteThing in the
     * IoT API Reference.
     */
    override suspend fun deleteCoreDevice(input: DeleteCoreDeviceRequest): DeleteCoreDeviceResponse {
        val op = SdkHttpOperation.build<DeleteCoreDeviceRequest, DeleteCoreDeviceResponse> {
            serializer = DeleteCoreDeviceOperationSerializer()
            deserializer = DeleteCoreDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteCoreDevice"
            }
        }
        registerDeleteCoreDeviceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves metadata for a version of a component.
     */
    override suspend fun describeComponent(input: DescribeComponentRequest): DescribeComponentResponse {
        val op = SdkHttpOperation.build<DescribeComponentRequest, DescribeComponentResponse> {
            serializer = DescribeComponentOperationSerializer()
            deserializer = DescribeComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeComponent"
            }
        }
        registerDescribeComponentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the recipe for a version of a component. Core devices can call this operation to
     * identify the artifacts and requirements to install a component.
     */
    override suspend fun getComponent(input: GetComponentRequest): GetComponentResponse {
        val op = SdkHttpOperation.build<GetComponentRequest, GetComponentResponse> {
            serializer = GetComponentOperationSerializer()
            deserializer = GetComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetComponent"
            }
        }
        registerGetComponentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the pre-signed URL to download a public component artifact. Core devices call this
     * operation to identify the URL that they can use to download an artifact to install.
     */
    override suspend fun getComponentVersionArtifact(input: GetComponentVersionArtifactRequest): GetComponentVersionArtifactResponse {
        val op = SdkHttpOperation.build<GetComponentVersionArtifactRequest, GetComponentVersionArtifactResponse> {
            serializer = GetComponentVersionArtifactOperationSerializer()
            deserializer = GetComponentVersionArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetComponentVersionArtifact"
            }
        }
        registerGetComponentVersionArtifactMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves metadata for a Greengrass core device.
     */
    override suspend fun getCoreDevice(input: GetCoreDeviceRequest): GetCoreDeviceResponse {
        val op = SdkHttpOperation.build<GetCoreDeviceRequest, GetCoreDeviceResponse> {
            serializer = GetCoreDeviceOperationSerializer()
            deserializer = GetCoreDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCoreDevice"
            }
        }
        registerGetCoreDeviceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a deployment. Deployments define the components that run on Greengrass core devices.
     */
    override suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse {
        val op = SdkHttpOperation.build<GetDeploymentRequest, GetDeploymentResponse> {
            serializer = GetDeploymentOperationSerializer()
            deserializer = GetDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeployment"
            }
        }
        registerGetDeploymentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of client devices that are associated with a core
     * device.
     */
    override suspend fun listClientDevicesAssociatedWithCoreDevice(input: ListClientDevicesAssociatedWithCoreDeviceRequest): ListClientDevicesAssociatedWithCoreDeviceResponse {
        val op = SdkHttpOperation.build<ListClientDevicesAssociatedWithCoreDeviceRequest, ListClientDevicesAssociatedWithCoreDeviceResponse> {
            serializer = ListClientDevicesAssociatedWithCoreDeviceOperationSerializer()
            deserializer = ListClientDevicesAssociatedWithCoreDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListClientDevicesAssociatedWithCoreDevice"
            }
        }
        registerListClientDevicesAssociatedWithCoreDeviceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of all versions for a component. Greater versions are listed first.
     */
    override suspend fun listComponentVersions(input: ListComponentVersionsRequest): ListComponentVersionsResponse {
        val op = SdkHttpOperation.build<ListComponentVersionsRequest, ListComponentVersionsResponse> {
            serializer = ListComponentVersionsOperationSerializer()
            deserializer = ListComponentVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponentVersions"
            }
        }
        registerListComponentVersionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of component summaries. This list includes components that you
     * have permission to view.
     */
    override suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse {
        val op = SdkHttpOperation.build<ListComponentsRequest, ListComponentsResponse> {
            serializer = ListComponentsOperationSerializer()
            deserializer = ListComponentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponents"
            }
        }
        registerListComponentsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of Greengrass core devices.
     */
    override suspend fun listCoreDevices(input: ListCoreDevicesRequest): ListCoreDevicesResponse {
        val op = SdkHttpOperation.build<ListCoreDevicesRequest, ListCoreDevicesResponse> {
            serializer = ListCoreDevicesOperationSerializer()
            deserializer = ListCoreDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCoreDevices"
            }
        }
        registerListCoreDevicesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of deployments.
     */
    override suspend fun listDeployments(input: ListDeploymentsRequest): ListDeploymentsResponse {
        val op = SdkHttpOperation.build<ListDeploymentsRequest, ListDeploymentsResponse> {
            serializer = ListDeploymentsOperationSerializer()
            deserializer = ListDeploymentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeployments"
            }
        }
        registerListDeploymentsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core
     * devices.
     */
    override suspend fun listEffectiveDeployments(input: ListEffectiveDeploymentsRequest): ListEffectiveDeploymentsResponse {
        val op = SdkHttpOperation.build<ListEffectiveDeploymentsRequest, ListEffectiveDeploymentsResponse> {
            serializer = ListEffectiveDeploymentsOperationSerializer()
            deserializer = ListEffectiveDeploymentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEffectiveDeployments"
            }
        }
        registerListEffectiveDeploymentsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of the components that a Greengrass core device runs.
     */
    override suspend fun listInstalledComponents(input: ListInstalledComponentsRequest): ListInstalledComponentsResponse {
        val op = SdkHttpOperation.build<ListInstalledComponentsRequest, ListInstalledComponentsResponse> {
            serializer = ListInstalledComponentsOperationSerializer()
            deserializer = ListInstalledComponentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInstalledComponents"
            }
        }
        registerListInstalledComponentsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the list of tags for an IoT Greengrass resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of components that meet the component, version, and platform requirements
     * of a deployment. Greengrass core devices call this operation when they receive a deployment to
     * identify the components to install.
     * This operation identifies components that meet all dependency requirements for a
     * deployment. If the requirements conflict, then this operation returns an error and the
     * deployment fails. For example, this occurs if component A requires version
     * >2.0.0 and component B requires version <2.0.0
     * of a component dependency.
     * When you specify the component candidates to resolve, IoT Greengrass compares each component's
     * digest from the core device with the component's digest in the Amazon Web Services Cloud. If the digests don't
     * match, then IoT Greengrass specifies to use the version from the Amazon Web Services Cloud.
     * To use this operation, you must use the data plane API endpoint and authenticate with an
     * IoT device certificate. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/greengrass.html">IoT Greengrass endpoints and quotas.
     */
    override suspend fun resolveComponentCandidates(input: ResolveComponentCandidatesRequest): ResolveComponentCandidatesResponse {
        val op = SdkHttpOperation.build<ResolveComponentCandidatesRequest, ResolveComponentCandidatesResponse> {
            serializer = ResolveComponentCandidatesOperationSerializer()
            deserializer = ResolveComponentCandidatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResolveComponentCandidates"
            }
        }
        registerResolveComponentCandidatesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this operation
     * updates the tag's value.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from an IoT Greengrass resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
